/*
 * Decompiled with CFR 0.152.
 */
package hivemall.model;

import hivemall.utils.hashing.MurmurHash3;
import hivemall.utils.lang.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.io.Text;

public final class FeatureValue {
    private Object feature;
    private double value;

    public FeatureValue() {
    }

    public FeatureValue(Object f, float v) {
        this.feature = f;
        this.value = v;
    }

    public FeatureValue(Object f, double v) {
        this.feature = f;
        this.value = v;
    }

    public <T> T getFeature() {
        return (T)this.feature;
    }

    public int getFeatureAsInt() {
        Preconditions.checkNotNull(this.feature);
        Preconditions.checkArgument(this.feature instanceof Integer);
        return (Integer)this.feature;
    }

    public String getFeatureAsString() {
        return this.feature.toString();
    }

    public double getValue() {
        return this.value;
    }

    public float getValueAsFloat() {
        return (float)this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Nullable
    public static FeatureValue parse(Object o) throws IllegalArgumentException {
        return FeatureValue.parse(o, false);
    }

    @Nullable
    public static FeatureValue parse(Object o, boolean mhash) throws IllegalArgumentException {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        return FeatureValue.parse(s, mhash);
    }

    @Nullable
    public static FeatureValue parse(@Nonnull String s) throws IllegalArgumentException {
        return FeatureValue.parse(s, false);
    }

    @Nullable
    public static FeatureValue parse(@Nonnull String s, boolean mhash) throws IllegalArgumentException {
        double weight;
        Object feature;
        int pos = s.indexOf(58);
        if (pos == 0) {
            throw new IllegalArgumentException("Invalid feature value representation: " + s);
        }
        if (pos > 0) {
            String s1 = s.substring(0, pos);
            String s2 = s.substring(pos + 1);
            feature = mhash ? Integer.valueOf(MurmurHash3.murmurhash3(s1)) : new Text(s1);
            try {
                weight = Double.parseDouble(s2);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse a feature value: " + s, e);
            }
        } else {
            feature = mhash ? Integer.valueOf(MurmurHash3.murmurhash3(s)) : new Text(s);
            weight = 1.0;
        }
        return new FeatureValue(feature, weight);
    }

    @Nonnull
    public static FeatureValue parseFeatureAsString(@Nonnull Text t) {
        String s = t.toString();
        return FeatureValue.parseFeatureAsString(s);
    }

    @Nonnull
    public static FeatureValue parseFeatureAsString(@Nonnull String s) throws IllegalArgumentException {
        double weight;
        String feature;
        int pos = s.indexOf(58);
        if (pos == 0) {
            throw new IllegalArgumentException("Invalid feature value representation: " + s);
        }
        if (pos > 0) {
            feature = s.substring(0, pos);
            String s2 = s.substring(pos + 1);
            try {
                weight = Double.parseDouble(s2);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse a feature value: " + s, e);
            }
        } else {
            feature = s;
            weight = 1.0;
        }
        return new FeatureValue((Object)feature, weight);
    }

    public static void parseFeatureAsString(@Nonnull Text t, @Nonnull FeatureValue probe) {
        String s = t.toString();
        FeatureValue.parseFeatureAsString(s, probe);
    }

    public static void parseFeatureAsString(@Nonnull String s, @Nonnull FeatureValue probe) throws IllegalArgumentException {
        int pos = s.indexOf(58);
        if (pos == 0) {
            throw new IllegalArgumentException("Invalid feature value representation: " + s);
        }
        if (pos > 0) {
            probe.feature = s.substring(0, pos);
            String s2 = s.substring(pos + 1);
            try {
                probe.value = Double.parseDouble(s2);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse a feature value: " + s, e);
            }
        } else {
            probe.feature = s;
            probe.value = 1.0;
        }
    }

    public String toString() {
        return this.feature + ":" + this.value;
    }
}

