/*
 * Decompiled with CFR 0.152.
 */
package hivemall.model;

import hivemall.model.AbstractPredictionModel;
import hivemall.model.IWeightValue;
import hivemall.model.WeightValue;
import hivemall.utils.collections.IMapIterator;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.Copyable;
import hivemall.utils.math.MathUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NewDenseModel
extends AbstractPredictionModel {
    private static final Log logger = LogFactory.getLog(NewDenseModel.class);
    private int size;
    private float[] weights;
    private float[] covars;
    private short[] clocks;
    private byte[] deltaUpdates;

    public NewDenseModel(int ndims) {
        this(ndims, false);
    }

    public NewDenseModel(int ndims, boolean withCovar) {
        int size;
        this.size = size = ndims + 1;
        this.weights = new float[size];
        if (withCovar) {
            float[] covars = new float[size];
            Arrays.fill(covars, 1.0f);
            this.covars = covars;
        } else {
            this.covars = null;
        }
        this.clocks = null;
        this.deltaUpdates = null;
    }

    @Override
    protected boolean isDenseModel() {
        return true;
    }

    @Override
    public boolean hasCovariance() {
        return this.covars != null;
    }

    @Override
    public void configureParams(boolean sum_of_squared_gradients, boolean sum_of_squared_delta_x, boolean sum_of_gradients) {
    }

    @Override
    public void configureClock() {
        if (this.clocks == null) {
            this.clocks = new short[this.size];
            this.deltaUpdates = new byte[this.size];
        }
    }

    @Override
    public boolean hasClock() {
        return this.clocks != null;
    }

    @Override
    public void resetDeltaUpdates(int feature) {
        this.deltaUpdates[feature] = 0;
    }

    private void ensureCapacity(int index) {
        if (index >= this.size) {
            int bits = MathUtils.bitsRequired(index);
            int newSize = (1 << bits) + 1;
            int oldSize = this.size;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Expands internal array size from " + oldSize + " to " + newSize + " (" + bits + " bits)"));
            }
            this.size = newSize;
            this.weights = Arrays.copyOf(this.weights, newSize);
            if (this.covars != null) {
                this.covars = Arrays.copyOf(this.covars, newSize);
                Arrays.fill(this.covars, oldSize, newSize, 1.0f);
            }
            if (this.clocks != null) {
                this.clocks = Arrays.copyOf(this.clocks, newSize);
                this.deltaUpdates = Arrays.copyOf(this.deltaUpdates, newSize);
            }
        }
    }

    @Override
    public <T extends IWeightValue> T get(@Nonnull Object feature) {
        int i = HiveUtils.parseInt(feature);
        if (i >= this.size) {
            return null;
        }
        if (this.covars != null) {
            return (T)new WeightValue.WeightValueWithCovar(this.weights[i], this.covars[i]);
        }
        return (T)new WeightValue(this.weights[i]);
    }

    @Override
    public <T extends IWeightValue> void set(@Nonnull Object feature, @Nonnull T value) {
        float weight;
        int i = HiveUtils.parseInt(feature);
        this.ensureCapacity(i);
        this.weights[i] = weight = value.get();
        float covar = 1.0f;
        boolean hasCovar = value.hasCovariance();
        if (hasCovar) {
            this.covars[i] = covar = value.getCovariance();
        }
        short clock = 0;
        int delta = 0;
        if (this.clocks != null && value.isTouched()) {
            this.clocks[i] = clock = (short)(this.clocks[i] + 1);
            delta = this.deltaUpdates[i] + 1;
            assert (delta > 0) : delta;
            this.deltaUpdates[i] = (byte)delta;
        }
        this.onUpdate(i, weight, covar, clock, delta, hasCovar);
    }

    @Override
    public void delete(@Nonnull Object feature) {
        int i = HiveUtils.parseInt(feature);
        if (i >= this.size) {
            return;
        }
        this.weights[i] = 0.0f;
        if (this.covars != null) {
            this.covars[i] = 1.0f;
        }
    }

    @Override
    public float getWeight(@Nonnull Object feature) {
        int i = HiveUtils.parseInt(feature);
        if (i >= this.size) {
            return 0.0f;
        }
        return this.weights[i];
    }

    @Override
    public void setWeight(@Nonnull Object feature, float value) {
        int i = HiveUtils.parseInt(feature);
        this.ensureCapacity(i);
        this.weights[i] = value;
    }

    @Override
    public float getCovariance(@Nonnull Object feature) {
        int i = HiveUtils.parseInt(feature);
        if (i >= this.size) {
            return 1.0f;
        }
        return this.covars[i];
    }

    @Override
    protected void _set(@Nonnull Object feature, float weight, short clock) {
        int i = (Integer)feature;
        this.ensureCapacity(i);
        this.weights[i] = weight;
        this.clocks[i] = clock;
        this.deltaUpdates[i] = 0;
    }

    @Override
    protected void _set(@Nonnull Object feature, float weight, float covar, short clock) {
        int i = (Integer)feature;
        this.ensureCapacity(i);
        this.weights[i] = weight;
        this.covars[i] = covar;
        this.clocks[i] = clock;
        this.deltaUpdates[i] = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(@Nonnull Object feature) {
        int i = HiveUtils.parseInt(feature);
        if (i >= this.size) {
            return false;
        }
        float w = this.weights[i];
        return w != 0.0f;
    }

    @Override
    public <K, V extends IWeightValue> IMapIterator<K, V> entries() {
        return new Itr();
    }

    private final class Itr
    implements IMapIterator<Number, IWeightValue> {
        private int cursor = -1;
        private final WeightValue.WeightValueWithCovar tmpWeight = new WeightValue.WeightValueWithCovar();

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < NewDenseModel.this.size;
        }

        @Override
        public int next() {
            ++this.cursor;
            if (!this.hasNext()) {
                return -1;
            }
            return this.cursor;
        }

        @Override
        public Integer getKey() {
            return this.cursor;
        }

        @Override
        public IWeightValue getValue() {
            if (NewDenseModel.this.covars == null) {
                float w = NewDenseModel.this.weights[this.cursor];
                WeightValue v = new WeightValue(w);
                v.setTouched(w != 0.0f);
                return v;
            }
            float w = NewDenseModel.this.weights[this.cursor];
            float cov = NewDenseModel.this.covars[this.cursor];
            WeightValue.WeightValueWithCovar v = new WeightValue.WeightValueWithCovar(w, cov);
            v.setTouched(w != 0.0f || cov != 1.0f);
            return v;
        }

        @Override
        public <T extends Copyable<IWeightValue>> void getValue(@Nonnull T probe) {
            float w;
            this.tmpWeight.value = w = NewDenseModel.this.weights[this.cursor];
            float cov = 1.0f;
            if (NewDenseModel.this.covars != null) {
                cov = NewDenseModel.this.covars[this.cursor];
                this.tmpWeight.setCovariance(cov);
            }
            this.tmpWeight.setTouched(w != 0.0f || cov != 1.0f);
            probe.copyFrom((WeightValue.WeightValueWithCovar)this.tmpWeight);
        }
    }
}

