/*
 * Decompiled with CFR 0.152.
 */
package hivemall.model;

import hivemall.model.AbstractPredictionModel;
import hivemall.model.IWeightValue;
import hivemall.model.WeightValue;
import hivemall.model.WeightValueWithClock;
import hivemall.utils.collections.IMapIterator;
import hivemall.utils.collections.maps.OpenHashTable;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NewSparseModel
extends AbstractPredictionModel {
    private static final Log logger = LogFactory.getLog(NewSparseModel.class);
    @Nonnull
    private final OpenHashTable<Object, IWeightValue> weights;
    private final boolean hasCovar;
    private boolean clockEnabled;

    public NewSparseModel(int size) {
        this(size, false);
    }

    public NewSparseModel(int size, boolean hasCovar) {
        this.weights = new OpenHashTable(size);
        this.hasCovar = hasCovar;
        this.clockEnabled = false;
    }

    @Override
    protected boolean isDenseModel() {
        return false;
    }

    @Override
    public boolean hasCovariance() {
        return this.hasCovar;
    }

    @Override
    public void configureParams(boolean sum_of_squared_gradients, boolean sum_of_squared_delta_x, boolean sum_of_gradients) {
    }

    @Override
    public void configureClock() {
        this.clockEnabled = true;
    }

    @Override
    public boolean hasClock() {
        return this.clockEnabled;
    }

    @Override
    public <T extends IWeightValue> T get(@Nonnull Object feature) {
        return (T)this.weights.get(feature);
    }

    @Override
    public <T extends IWeightValue> void set(@Nonnull Object feature, @Nonnull T value) {
        IWeightValue old;
        IWeightValue wrapperValue = this.wrapIfRequired(value);
        if (this.clockEnabled && value.isTouched() && (old = this.weights.get(feature)) != null) {
            short newclock = (short)(old.getClock() + 1);
            wrapperValue.setClock(newclock);
            int newDelta = old.getDeltaUpdates() + 1;
            wrapperValue.setDeltaUpdates((byte)newDelta);
        }
        this.weights.put(feature, wrapperValue);
        this.onUpdate(feature, wrapperValue);
    }

    @Override
    public void delete(@Nonnull Object feature) {
        this.weights.remove(feature);
    }

    @Nonnull
    private IWeightValue wrapIfRequired(@Nonnull IWeightValue value) {
        IWeightValue wrapper;
        block8: {
            block7: {
                if (!this.clockEnabled) break block7;
                switch (value.getType()) {
                    case NoParams: {
                        wrapper = new WeightValueWithClock(value);
                        break block8;
                    }
                    case ParamsCovar: {
                        wrapper = new WeightValueWithClock.WeightValueWithCovarClock(value);
                        break block8;
                    }
                    case ParamsF1: {
                        wrapper = new WeightValueWithClock.WeightValueParamsF1Clock(value);
                        break block8;
                    }
                    case ParamsF2: {
                        wrapper = new WeightValueWithClock.WeightValueParamsF2Clock(value);
                        break block8;
                    }
                    case ParamsF3: {
                        wrapper = new WeightValueWithClock.WeightValueParamsF3Clock(value);
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value type: " + (Object)((Object)value.getType()));
                    }
                }
            }
            wrapper = value;
        }
        return wrapper;
    }

    @Override
    public float getWeight(@Nonnull Object feature) {
        IWeightValue v = this.weights.get(feature);
        return v == null ? 0.0f : v.get();
    }

    @Override
    public void setWeight(@Nonnull Object feature, float value) {
        if (this.weights.containsKey(feature)) {
            IWeightValue weight = this.weights.get(feature);
            weight.set(value);
        } else {
            WeightValue weight = new WeightValue(value);
            weight.set(value);
            this.weights.put(feature, weight);
        }
    }

    @Override
    public float getCovariance(@Nonnull Object feature) {
        IWeightValue v = this.weights.get(feature);
        return v == null ? 1.0f : v.getCovariance();
    }

    @Override
    protected void _set(@Nonnull Object feature, float weight, short clock) {
        IWeightValue w = this.weights.get(feature);
        if (w == null) {
            logger.warn((Object)("Previous weight not found: " + feature));
            throw new IllegalStateException("Previous weight not found " + feature);
        }
        w.set(weight);
        w.setClock(clock);
        w.setDeltaUpdates((byte)0);
    }

    @Override
    protected void _set(@Nonnull Object feature, float weight, float covar, short clock) {
        IWeightValue w = this.weights.get(feature);
        if (w == null) {
            logger.warn((Object)("Previous weight not found: " + feature));
            throw new IllegalStateException("Previous weight not found: " + feature);
        }
        w.set(weight);
        w.setCovariance(covar);
        w.setClock(clock);
        w.setDeltaUpdates((byte)0);
    }

    @Override
    public int size() {
        return this.weights.size();
    }

    @Override
    public boolean contains(@Nonnull Object feature) {
        return this.weights.containsKey(feature);
    }

    @Override
    public <K, V extends IWeightValue> IMapIterator<K, V> entries() {
        return this.weights.entries(true);
    }
}

