/*
 * Decompiled with CFR 0.152.
 */
package hivemall.model;

import hivemall.model.IWeightValue;
import javax.annotation.Nonnegative;

public class WeightValue
implements IWeightValue {
    protected float value;
    protected boolean touched;

    public WeightValue() {
    }

    public WeightValue(float weight) {
        this(weight, true);
    }

    public WeightValue(float weight, boolean touched) {
        this.value = weight;
        this.touched = touched;
    }

    @Override
    public IWeightValue.WeightValueType getType() {
        return IWeightValue.WeightValueType.NoParams;
    }

    @Override
    public float getFloatParams(@Nonnegative int i) {
        throw new UnsupportedOperationException("getFloatParams(int) should not be called");
    }

    @Override
    public final float get() {
        return this.value;
    }

    @Override
    public final void set(float weight) {
        this.value = weight;
    }

    @Override
    public boolean hasCovariance() {
        return false;
    }

    @Override
    public float getCovariance() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCovariance(float cov) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getSumOfSquaredGradients() {
        return 0.0f;
    }

    @Override
    public void setSumOfSquaredGradients(float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getSumOfSquaredDeltaX() {
        return 0.0f;
    }

    @Override
    public void setSumOfSquaredDeltaX(float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getDelta() {
        return 0.0f;
    }

    @Override
    public void setDelta(float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getSumOfGradients() {
        return 0.0f;
    }

    @Override
    public void setSumOfGradients(float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getM() {
        return 0.0f;
    }

    @Override
    public void setM(float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getV() {
        return 0.0f;
    }

    @Override
    public void setV(float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isTouched() {
        return this.touched;
    }

    @Override
    public final void setTouched(boolean touched) {
        this.touched = touched;
    }

    @Override
    public final short getClock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setClock(short clock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte getDeltaUpdates() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setDeltaUpdates(byte deltaUpdates) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyTo(IWeightValue another) {
        another.set(this.value);
        another.setTouched(this.touched);
    }

    @Override
    public void copyFrom(IWeightValue another) {
        this.value = another.get();
        this.touched = another.isTouched();
    }

    public String toString() {
        return "WeightValue [value=" + this.value + "]";
    }

    public static final class WeightValueWithCovar
    extends WeightValue {
        public static final float DEFAULT_COVAR = 1.0f;
        private float covariance;

        public WeightValueWithCovar() {
        }

        public WeightValueWithCovar(float weight, float covariance) {
            this(weight, covariance, true);
        }

        public WeightValueWithCovar(float weight, float covariance, boolean touched) {
            super(weight, touched);
            this.covariance = covariance;
        }

        @Override
        public IWeightValue.WeightValueType getType() {
            return IWeightValue.WeightValueType.ParamsCovar;
        }

        @Override
        public boolean hasCovariance() {
            return true;
        }

        @Override
        public float getCovariance() {
            return this.covariance;
        }

        @Override
        public void setCovariance(float cov) {
            this.covariance = cov;
        }

        @Override
        public void copyTo(IWeightValue another) {
            super.copyTo(another);
            another.setCovariance(this.covariance);
        }

        @Override
        public void copyFrom(IWeightValue another) {
            super.copyFrom(another);
            this.covariance = another.getCovariance();
        }

        @Override
        public String toString() {
            return "WeightValueWithCovar [value=" + this.value + ", covariance=" + this.covariance + "]";
        }
    }

    public static final class WeightValueParamsF3
    extends WeightValue {
        private float f1;
        private float f2;
        private float f3;

        public WeightValueParamsF3(float weight, float f1, float f2, float f3) {
            super(weight);
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
        }

        @Override
        public IWeightValue.WeightValueType getType() {
            return IWeightValue.WeightValueType.ParamsF3;
        }

        @Override
        public float getFloatParams(@Nonnegative int i) {
            if (i == 1) {
                return this.f1;
            }
            if (i == 2) {
                return this.f2;
            }
            if (i == 3) {
                return this.f3;
            }
            throw new IllegalArgumentException("getFloatParams(" + i + ") should not be called");
        }

        @Override
        public float getSumOfSquaredGradients() {
            return this.f1;
        }

        @Override
        public void setSumOfSquaredGradients(float value) {
            this.f1 = value;
        }

        @Override
        public float getSumOfSquaredDeltaX() {
            return this.f2;
        }

        @Override
        public void setSumOfSquaredDeltaX(float value) {
            this.f2 = value;
        }

        @Override
        public float getDelta() {
            return this.f2;
        }

        @Override
        public void setDelta(float value) {
            this.f2 = value;
        }

        @Override
        public float getSumOfGradients() {
            return this.f3;
        }

        @Override
        public void setSumOfGradients(float value) {
            this.f3 = value;
        }

        @Override
        public float getM() {
            return this.f1;
        }

        @Override
        public void setM(float value) {
            this.f1 = value;
        }

        @Override
        public float getV() {
            return this.f2;
        }

        @Override
        public void setV(float value) {
            this.f2 = value;
        }
    }

    public static final class WeightValueParamsF2
    extends WeightValue {
        private float f1;
        private float f2;

        public WeightValueParamsF2(float weight, float f1, float f2) {
            super(weight);
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public IWeightValue.WeightValueType getType() {
            return IWeightValue.WeightValueType.ParamsF2;
        }

        @Override
        public float getFloatParams(@Nonnegative int i) {
            if (i == 1) {
                return this.f1;
            }
            if (i == 2) {
                return this.f2;
            }
            throw new IllegalArgumentException("getFloatParams(" + i + ") should not be called");
        }

        @Override
        public final float getSumOfSquaredGradients() {
            return this.f1;
        }

        @Override
        public void setSumOfSquaredGradients(float value) {
            this.f1 = value;
        }

        @Override
        public final float getSumOfSquaredDeltaX() {
            return this.f2;
        }

        @Override
        public void setSumOfSquaredDeltaX(float value) {
            this.f2 = value;
        }

        @Override
        public float getSumOfGradients() {
            return this.f2;
        }

        @Override
        public void setSumOfGradients(float value) {
            this.f2 = value;
        }

        @Override
        public float getM() {
            return this.f1;
        }

        @Override
        public void setM(float value) {
            this.f1 = value;
        }

        @Override
        public float getV() {
            return this.f2;
        }

        @Override
        public void setV(float value) {
            this.f2 = value;
        }
    }

    public static final class WeightValueParamsF1
    extends WeightValue {
        private float f1;

        public WeightValueParamsF1(float weight, float f1) {
            super(weight);
            this.f1 = f1;
        }

        @Override
        public IWeightValue.WeightValueType getType() {
            return IWeightValue.WeightValueType.ParamsF1;
        }

        @Override
        public float getFloatParams(@Nonnegative int i) {
            if (i == 1) {
                return this.f1;
            }
            throw new IllegalArgumentException("getFloatParams(" + i + ") should not be called");
        }

        @Override
        public final float getSumOfSquaredGradients() {
            return this.f1;
        }

        @Override
        public void setSumOfSquaredGradients(float value) {
            this.f1 = value;
        }

        @Override
        public float getDelta() {
            return this.f1;
        }

        @Override
        public void setDelta(float value) {
            this.f1 = value;
        }
    }
}

