/*
 * Decompiled with CFR 0.152.
 */
package hivemall.regression;

import hivemall.model.FeatureValue;
import hivemall.model.IWeightValue;
import hivemall.model.WeightValue;
import hivemall.optimizer.LossFunctions;
import hivemall.regression.RegressionBaseUDTF;
import hivemall.utils.lang.Primitives;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Deprecated
@Description(name="train_adagrad_regr", value="_FUNC_(array<int|bigint|string> features, float target [, constant string options]) - Returns a relation consists of <{int|bigint|string} feature, float weight>")
public final class AdaGradUDTF
extends RegressionBaseUDTF {
    private float eta;
    private float eps;
    private float scaling;

    @Override
    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int numArgs = argOIs.length;
        if (numArgs != 2 && numArgs != 3) {
            throw new UDFArgumentException("_FUNC_ takes 2 or 3 arguments: List<Text|Int|BitInt> features, float target [, constant string options]");
        }
        StructObjectInspector oi = super.initialize(argOIs);
        this.model.configureParams(true, false, false);
        return oi;
    }

    @Override
    protected Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption("eta", "eta0", true, "The initial learning rate [default 1.0]");
        opts.addOption("eps", true, "A constant used in the denominator of AdaGrad [default 1.0]");
        opts.addOption("scale", true, "Internal scaling/descaling factor for cumulative weights [100]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        CommandLine cl = super.processOptions(argOIs);
        if (cl == null) {
            this.eta = 1.0f;
            this.eps = 1.0f;
            this.scaling = 100.0f;
        } else {
            this.eta = Primitives.parseFloat(cl.getOptionValue("eta"), 1.0f);
            this.eps = Primitives.parseFloat(cl.getOptionValue("eps"), 1.0f);
            this.scaling = Primitives.parseFloat(cl.getOptionValue("scale"), 100.0f);
        }
        return cl;
    }

    @Override
    protected final void checkTargetValue(float target) throws UDFArgumentException {
        if (target < 0.0f || target > 1.0f) {
            throw new UDFArgumentException("target must be in range 0 to 1: " + target);
        }
    }

    @Override
    protected void update(@Nonnull FeatureValue[] features, float target, float predicted) {
        float gradient = LossFunctions.logisticLoss(target, predicted);
        this.onlineUpdate(features, gradient);
    }

    @Override
    protected void onlineUpdate(@Nonnull FeatureValue[] features, float gradient) {
        float g_g = gradient * (gradient / this.scaling);
        for (FeatureValue f : features) {
            if (f == null) continue;
            Object x = f.getFeature();
            float xi = f.getValueAsFloat();
            Object old_w = this.model.get(x);
            IWeightValue new_w = this.getNewWeight((IWeightValue)old_w, xi, gradient, g_g);
            this.model.set(x, new_w);
        }
    }

    @Nonnull
    protected IWeightValue getNewWeight(@Nullable IWeightValue old, float xi, float gradient, float g_g) {
        float old_w = 0.0f;
        float scaled_sum_sqgrad = 0.0f;
        if (old != null) {
            old_w = old.get();
            scaled_sum_sqgrad = old.getSumOfSquaredGradients();
        }
        float coeff = this.eta(scaled_sum_sqgrad += g_g) * gradient;
        float new_w = old_w + coeff * xi;
        return new WeightValue.WeightValueParamsF1(new_w, scaled_sum_sqgrad);
    }

    protected float eta(double scaledSumOfSquaredGradients) {
        double sumOfSquaredGradients = scaledSumOfSquaredGradients * (double)this.scaling;
        return this.eta / (float)Math.sqrt((double)this.eps + sumOfSquaredGradients);
    }
}

