/*
 * Decompiled with CFR 0.152.
 */
package hivemall.sketch.bloom;

import hivemall.sketch.bloom.BloomFilterUtils;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.bloom.DynamicBloomFilter;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.hadoop.util.bloom.Key;

@Description(name="bloom_contains_any", value="_FUNC_(string bloom, string key) or _FUNC_(string bloom, array<string> keys)- Returns true if the bloom filter contains any of the given key", extended="WITH data1 as (\n  SELECT explode(array(1,2,3,4,5)) as id\n),\ndata2 as (\n  SELECT explode(array(1,3,5,6,8)) as id\n),\nbloom as (\n  SELECT bloom(id) as bf\n  FROM data1\n)\nSELECT \n  l.* \nFROM \n  data2 l\n  CROSS JOIN bloom r\nWHERE\n  bloom_contains_any(r.bf, array(l.id))")
@UDFType(deterministic=true, stateful=false)
public final class BloomContainsAnyUDF
extends UDF {
    @Nonnull
    private final Key key = new Key();
    @Nullable
    private Text prevBfStr;
    @Nullable
    private Filter prevBf;

    @Nullable
    public Boolean evaluate(@Nullable Text bloomStr, @Nullable List<Text> keys) throws HiveException {
        if (bloomStr == null) {
            return null;
        }
        if (keys == null) {
            return Boolean.FALSE;
        }
        Filter bloom = this.getFilter(bloomStr);
        for (Text keyStr : keys) {
            if (keyStr == null) continue;
            this.key.set(keyStr.copyBytes(), 1.0);
            if (!bloom.membershipTest(this.key)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Nonnull
    private Filter getFilter(@Nonnull Text bloomStr) throws HiveException {
        DynamicBloomFilter bloom;
        if (this.prevBf != null && this.prevBfStr.equals((Object)bloomStr)) {
            bloom = this.prevBf;
        } else {
            try {
                bloom = BloomFilterUtils.deserialize(bloomStr, new DynamicBloomFilter());
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
            this.prevBfStr = new Text(bloomStr);
            this.prevBf = bloom;
        }
        return bloom;
    }
}

