/*
 * Decompiled with CFR 0.152.
 */
package hivemall.sketch.bloom;

import hivemall.sketch.bloom.BloomFilterUtils;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.bloom.DynamicBloomFilter;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.hadoop.util.bloom.Key;

@Description(name="bloom_contains", value="_FUNC_(string bloom, string key) or _FUNC_(string bloom, array<string> keys) - Returns true if the bloom filter contains all the given key(s). Returns false if key is null.", extended="WITH satisfied_movies as (\n  SELECT bloom(movieid) as movies\n  FROM (\n    SELECT movieid\n    FROM ratings\n    GROUP BY movieid\n    HAVING avg(rating) >= 4.0\n  ) t\n)\nSELECT\n  l.rating,\n  count(distinct l.userid) as cnt\nFROM\n  ratings l \n  CROSS JOIN satisfied_movies r\nWHERE\n  bloom_contains(r.movies, l.movieid) -- includes false positive\nGROUP BY \n  l.rating;\n\nl.rating        cnt\n1       1296\n2       2770\n3       5008\n4       5824\n5       5925")
@UDFType(deterministic=true, stateful=false)
public final class BloomContainsUDF
extends UDF {
    @Nonnull
    private final Key key = new Key();
    @Nullable
    private Text prevBfStr;
    @Nullable
    private Filter prevBf;

    @Nullable
    public Boolean evaluate(@Nullable Text bloomStr, @Nullable Text keyStr) throws HiveException {
        if (bloomStr == null) {
            return null;
        }
        if (keyStr == null) {
            return Boolean.FALSE;
        }
        Filter bloom = this.getFilter(bloomStr);
        this.key.set(keyStr.copyBytes(), 1.0);
        return bloom.membershipTest(this.key);
    }

    @Nullable
    public Boolean evaluate(@Nullable Text bloomStr, @Nullable List<Text> keys) throws HiveException {
        if (bloomStr == null) {
            return null;
        }
        if (keys == null) {
            return Boolean.FALSE;
        }
        Filter bloom = this.getFilter(bloomStr);
        for (Text keyStr : keys) {
            if (keyStr == null) continue;
            this.key.set(keyStr.copyBytes(), 1.0);
            if (bloom.membershipTest(this.key)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Nonnull
    private Filter getFilter(@Nonnull Text bloomStr) throws HiveException {
        DynamicBloomFilter bloom;
        if (this.prevBf != null && this.prevBfStr.equals((Object)bloomStr)) {
            bloom = this.prevBf;
        } else {
            try {
                bloom = BloomFilterUtils.deserialize(bloomStr, new DynamicBloomFilter());
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
            this.prevBfStr = new Text(bloomStr);
            this.prevBf = bloom;
        }
        return bloom;
    }
}

