/*
 * Decompiled with CFR 0.152.
 */
package hivemall.sketch.bloom;

import hivemall.sketch.bloom.BloomFilterUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.bloom.DynamicBloomFilter;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.hadoop.util.bloom.Key;

@Description(name="bloom", value="_FUNC_(string key) - Constructs a BloomFilter by aggregating a set of keys", extended="CREATE TABLE satisfied_movies AS \n  SELECT bloom(movieid) as movies\n  FROM (\n    SELECT movieid\n    FROM ratings\n    GROUP BY movieid\n    HAVING avg(rating) >= 4.0\n  ) t;")
public final class BloomFilterUDAF
extends UDAF {

    public static class Evaluator
    implements UDAFEvaluator {
        private Filter filter;
        private Key key;

        public void init() {
            this.filter = BloomFilterUtils.newDynamicBloomFilter();
            this.key = new Key();
        }

        public boolean iterate(@Nullable Text keyStr) {
            if (keyStr == null) {
                return true;
            }
            if (this.filter == null) {
                this.init();
            }
            this.key.set(keyStr.copyBytes(), 1.0);
            this.filter.add(this.key);
            return true;
        }

        @Nonnull
        public Text terminatePartial() throws HiveException {
            try {
                return BloomFilterUtils.serialize(this.filter, new Text());
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }

        public boolean merge(@Nonnull Text partial) throws HiveException {
            DynamicBloomFilter other;
            try {
                other = BloomFilterUtils.deserialize(partial, new DynamicBloomFilter());
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
            if (this.filter == null) {
                this.filter = other;
            } else {
                this.filter.or((Filter)other);
            }
            return true;
        }

        @Nullable
        public Text terminate() throws HiveException {
            if (this.filter == null) {
                return null;
            }
            try {
                return BloomFilterUtils.serialize(this.filter, new Text());
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }
    }
}

