/*
 * Decompiled with CFR 0.152.
 */
package hivemall.sketch.bloom;

import hivemall.utils.io.Base91InputStream;
import hivemall.utils.io.Base91OutputStream;
import hivemall.utils.io.FastByteArrayInputStream;
import hivemall.utils.io.FastByteArrayOutputStream;
import hivemall.utils.math.MathUtils;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.DynamicBloomFilter;
import org.apache.hadoop.util.bloom.Filter;

public final class BloomFilterUtils {
    public static final int DEFAULT_BLOOM_FILTER_SIZE = 0x100000;
    public static final float DEFAULT_ERROR_RATE = 0.005f;
    public static final int NUM_HASHES = 5;

    @Nonnull
    public static BloomFilter newBloomFilter(@Nonnegative int expectedNumberOfElements) {
        return BloomFilterUtils.newBloomFilter(expectedNumberOfElements, 0.005f);
    }

    @Nonnull
    public static BloomFilter newBloomFilter(@Nonnegative int expectedNumberOfElements, @Nonnegative float errorRate) {
        int nbHash = Math.max(2, (int)Math.ceil(-(Math.log(errorRate) / MathUtils.LOG2)));
        return BloomFilterUtils.newBloomFilter(expectedNumberOfElements, errorRate, nbHash);
    }

    @Nonnull
    public static BloomFilter newBloomFilter(@Nonnegative int expectedNumberOfElements, @Nonnegative float errorRate, @Nonnegative int nbHash) {
        int vectorSize = (int)Math.ceil((double)(-nbHash * expectedNumberOfElements) / Math.log(1.0 - Math.pow(errorRate, 1.0 / (double)nbHash)));
        return new BloomFilter(vectorSize, nbHash, 1);
    }

    @Nonnull
    public static DynamicBloomFilter newDynamicBloomFilter() {
        return BloomFilterUtils.newDynamicBloomFilter(0x100000, 0.005f, 5);
    }

    @Nonnull
    public static DynamicBloomFilter newDynamicBloomFilter(@Nonnegative int expectedNumberOfElements) {
        return BloomFilterUtils.newDynamicBloomFilter(expectedNumberOfElements, 0.005f);
    }

    @Nonnull
    public static DynamicBloomFilter newDynamicBloomFilter(@Nonnegative int expectedNumberOfElements, @Nonnegative float errorRate) {
        int nbHash = Math.max(2, (int)Math.ceil(-(Math.log(errorRate) / MathUtils.LOG2)));
        return BloomFilterUtils.newDynamicBloomFilter(expectedNumberOfElements, errorRate, nbHash);
    }

    @Nonnull
    public static DynamicBloomFilter newDynamicBloomFilter(@Nonnegative int expectedNumberOfElements, @Nonnegative float errorRate, @Nonnegative int nbHash) {
        int vectorSize = (int)Math.ceil((double)(-nbHash * expectedNumberOfElements) / Math.log(1.0 - Math.pow(errorRate, 1.0 / (double)nbHash)));
        return new DynamicBloomFilter(vectorSize, nbHash, 1, expectedNumberOfElements);
    }

    @Nonnull
    public static byte[] serialize(@Nonnull Filter filter) throws IOException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        Base91OutputStream base91 = new Base91OutputStream(bos);
        DataOutputStream out = new DataOutputStream(base91);
        filter.write((DataOutput)out);
        out.flush();
        base91.finish();
        return bos.toByteArray();
    }

    @Nonnull
    public static Text serialize(@Nonnull Filter filter, @Nonnull Text dst) throws IOException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        Base91OutputStream base91 = new Base91OutputStream(bos);
        DataOutputStream out = new DataOutputStream(base91);
        filter.write((DataOutput)out);
        out.flush();
        base91.finish();
        dst.set(bos.getInternalArray(), 0, bos.size());
        return dst;
    }

    @Nonnull
    public static <F extends Filter> F deserialize(@Nonnull Text in, @Nonnull F dst) throws IOException {
        return BloomFilterUtils.deserialize(in.getBytes(), 0, in.getLength(), dst);
    }

    @Nonnull
    public static <F extends Filter> F deserialize(@Nonnull byte[] buf, @Nonnull F dst) throws IOException {
        return BloomFilterUtils.deserialize(buf, 0, buf.length, dst);
    }

    @Nonnull
    public static <F extends Filter> F deserialize(@Nonnull byte[] buf, @Nonnegative int offset, @Nonnegative int len, @Nonnull F dst) throws IOException {
        FastByteArrayInputStream fis = new FastByteArrayInputStream(buf, offset, len);
        DataInputStream in = new DataInputStream(new Base91InputStream(fis));
        dst.readFields((DataInput)in);
        return dst;
    }
}

