/*
 * Decompiled with CFR 0.152.
 */
package hivemall.sketch.bloom;

import hivemall.sketch.bloom.BloomFilterUtils;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.bloom.DynamicBloomFilter;
import org.apache.hadoop.util.bloom.Filter;

@Description(name="bloom_not", value="_FUNC_(string bloom) - Returns the logical NOT of a bloom filters", extended="SELECT bloom_not(bf) FROM xxx;")
@UDFType(deterministic=true, stateful=false)
public final class BloomNotUDF
extends UDF {
    @Nullable
    public Text evaluate(@Nullable Text bloomStr) throws HiveException {
        DynamicBloomFilter bloom;
        if (bloomStr == null) {
            return null;
        }
        try {
            bloom = BloomFilterUtils.deserialize(bloomStr, new DynamicBloomFilter());
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
        bloom.not();
        try {
            return BloomFilterUtils.serialize((Filter)bloom, new Text());
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }
}

