/*
 * Decompiled with CFR 0.152.
 */
package hivemall.sketch.bloom;

import hivemall.sketch.bloom.BloomFilterUtils;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.bloom.DynamicBloomFilter;
import org.apache.hadoop.util.bloom.Filter;

@Description(name="bloom_or", value="_FUNC_(string bloom1, string bloom2) - Returns the logical OR of two bloom filters", extended="SELECT bloom_or(bf1, bf2) FROM xxx;")
@UDFType(deterministic=true, stateful=false)
public final class BloomOrUDF
extends UDF {
    @Nullable
    public Text evaluate(@Nullable Text bloom1Str, @Nullable Text bloom2Str) throws HiveException {
        DynamicBloomFilter bloom2;
        DynamicBloomFilter bloom1;
        if (bloom1Str == null || bloom2Str == null) {
            return null;
        }
        try {
            bloom1 = BloomFilterUtils.deserialize(bloom1Str, new DynamicBloomFilter());
            bloom2 = BloomFilterUtils.deserialize(bloom2Str, new DynamicBloomFilter());
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
        bloom1.or((Filter)bloom2);
        try {
            return BloomFilterUtils.serialize((Filter)bloom1, new Text());
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }
}

