/*
 * Decompiled with CFR 0.152.
 */
package hivemall.sketch.hll;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import hivemall.UDAFEvaluatorWithOptions;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.Preconditions;
import hivemall.utils.lang.Primitives;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.LongWritable;

@Description(name="approx_count_distinct", value="_FUNC_(expr x [, const string options]) - Returns an approximation of count(DISTINCT x) using HyperLogLogPlus algorithm")
public final class ApproxCountDistinctUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(@Nonnull TypeInfo[] typeInfo) throws SemanticException {
        if (typeInfo.length != 1 && typeInfo.length != 2) {
            throw new UDFArgumentTypeException(typeInfo.length - 1, "_FUNC_ takes one or two arguments");
        }
        if (typeInfo.length == 2 && !HiveUtils.isStringTypeInfo(typeInfo[1])) {
            throw new UDFArgumentTypeException(1, "The second argument type expected to be const string: " + typeInfo[1]);
        }
        return new HLLEvaluator();
    }

    private static void validateArguments(int p, int sp2) throws UDFArgumentException {
        if (p < 4 || p > sp2) {
            throw new UDFArgumentException("p must be between 4 and sp (inclusive)");
        }
        if (sp2 > 32) {
            throw new UDFArgumentException("sp values greater than 32 not supported");
        }
    }

    @GenericUDAFEvaluator.AggregationType(estimable=true)
    static final class HLLBuffer
    extends GenericUDAFEvaluator.AbstractAggregationBuffer {
        @Nullable
        private HyperLogLogPlus hll;

        HLLBuffer() {
        }

        public int estimate() {
            return this.hll == null ? 0 : this.hll.sizeof();
        }

        void reset(@Nonnegative int p, @Nonnegative int sp2) {
            this.hll = new HyperLogLogPlus(p, sp2);
        }
    }

    public static final class HLLEvaluator
    extends UDAFEvaluatorWithOptions {
        @Nullable
        private int[] params;
        private ObjectInspector origInputOI;
        private BinaryObjectInspector mergeInputOI;

        @Override
        protected Options getOptions() {
            Options opts = new Options();
            opts.addOption("p", true, "The size of registers for the normal set. `p` MUST be in the range [4,sp] and 15 by the default");
            opts.addOption("sp", true, "The size of registers for the sparse set. `sp` MUST be in the range [4,32] and 25 by the default");
            return opts;
        }

        @Override
        protected CommandLine processOptions(@Nonnull ObjectInspector[] argOIs) throws UDFArgumentException {
            CommandLine cl = null;
            int p = 15;
            int sp2 = 25;
            if (argOIs.length == 2) {
                if (!HiveUtils.isConstString(argOIs[1])) {
                    throw new UDFArgumentException("The second argument type expected to be const string: " + argOIs[1]);
                }
                cl = this.parseOptions(HiveUtils.getConstString(argOIs[1]));
                p = Primitives.parseInt(cl.getOptionValue("p"), p);
                sp2 = Primitives.parseInt(cl.getOptionValue("sp"), sp2);
                ApproxCountDistinctUDAF.validateArguments(p, sp2);
            }
            this.params = new int[]{p, sp2};
            return cl;
        }

        public ObjectInspector init(@Nonnull GenericUDAFEvaluator.Mode mode, @Nonnull ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1 || parameters.length == 2) : parameters.length;
            super.init(mode, parameters);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.processOptions(parameters);
                this.origInputOI = parameters[0];
            } else {
                this.mergeInputOI = HiveUtils.asBinaryOI(parameters[0]);
            }
            Object outputOI = mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2 ? PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector : PrimitiveObjectInspectorFactory.writableLongObjectInspector;
            return outputOI;
        }

        public HLLBuffer getNewAggregationBuffer() throws HiveException {
            HLLBuffer buf = new HLLBuffer();
            if (this.params != null) {
                buf.reset(this.params[0], this.params[1]);
            }
            return buf;
        }

        public void reset(@Nonnull GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            HLLBuffer buf = (HLLBuffer)agg;
            if (this.params != null) {
                buf.reset(this.params[0], this.params[1]);
            } else {
                buf.hll = null;
            }
        }

        public void iterate(@Nonnull GenericUDAFEvaluator.AggregationBuffer agg, @Nonnull Object[] parameters) throws HiveException {
            if (parameters[0] == null) {
                return;
            }
            HLLBuffer buf = (HLLBuffer)agg;
            Object value = ObjectInspectorUtils.copyToStandardJavaObject((Object)parameters[0], (ObjectInspector)this.origInputOI);
            Preconditions.checkNotNull(buf.hll, HiveException.class);
            buf.hll.offer(value);
        }

        @Nullable
        public byte[] terminatePartial(@Nonnull GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            HLLBuffer buf = (HLLBuffer)agg;
            if (buf.hll == null) {
                return null;
            }
            try {
                return buf.hll.getBytes();
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }

        public void merge(@Nonnull GenericUDAFEvaluator.AggregationBuffer agg, @Nullable Object partial) throws HiveException {
            HyperLogLogPlus otherHLL;
            if (partial == null) {
                return;
            }
            byte[] data = this.mergeInputOI.getPrimitiveJavaObject(partial);
            try {
                otherHLL = HyperLogLogPlus.Builder.build(data);
            }
            catch (IOException e) {
                throw new HiveException("Failed to build other HLL");
            }
            HLLBuffer buf = (HLLBuffer)agg;
            if (buf.hll == null) {
                buf.hll = otherHLL;
            } else {
                try {
                    buf.hll.addAll(otherHLL);
                }
                catch (CardinalityMergeException e) {
                    throw new HiveException("Failed to merge HLL");
                }
            }
        }

        public LongWritable terminate(@Nonnull GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            HLLBuffer buf = (HLLBuffer)agg;
            long cardinality = buf.hll == null ? 0L : buf.hll.cardinality();
            return new LongWritable(cardinality);
        }
    }
}

