/*
 * Decompiled with CFR 0.152.
 */
package hivemall.smile.classification;

import hivemall.UDTFWithOptions;
import hivemall.smile.classification.DecisionTree;
import hivemall.smile.utils.SmileExtUtils;
import hivemall.smile.utils.SmileTaskExecutor;
import hivemall.utils.codec.Base91;
import hivemall.utils.collections.lists.IntArrayList;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.hadoop.SerdeUtils;
import hivemall.utils.hadoop.WritableUtils;
import hivemall.utils.lang.Preconditions;
import hivemall.utils.lang.Primitives;
import hivemall.utils.lang.RandomUtils;
import hivemall.utils.random.PRNG;
import hivemall.utils.random.RandomNumberGeneratorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import matrix4j.matrix.Matrix;
import matrix4j.matrix.MatrixUtils;
import matrix4j.matrix.builders.CSRMatrixBuilder;
import matrix4j.matrix.builders.MatrixBuilder;
import matrix4j.matrix.builders.RowMajorDenseMatrixBuilder;
import matrix4j.matrix.ints.DoKIntMatrix;
import matrix4j.matrix.ints.IntMatrix;
import matrix4j.vector.Vector;
import matrix4j.vector.VectorProcedure;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.MapredContextAccessor;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.Reporter;
import org.roaringbitmap.RoaringBitmap;
import smile.math.Math;

@Description(name="train_randomforest_classifier", value="_FUNC_(array<double|string> features, int label [, const string options, const array<double> classWeights])- Returns a relation consists of <string model_id, double model_weight, string model, array<double> var_importance, int oob_errors, int oob_tests>")
public final class RandomForestClassifierUDTF
extends UDTFWithOptions {
    private static final Log logger = LogFactory.getLog(RandomForestClassifierUDTF.class);
    private ListObjectInspector featureListOI;
    private PrimitiveObjectInspector featureElemOI;
    private PrimitiveObjectInspector labelOI;
    private boolean denseInput;
    private MatrixBuilder matrixBuilder;
    private IntArrayList labels;
    private int _numTrees;
    private float _numVars;
    private int _maxDepth;
    private int _maxLeafNodes;
    private int _minSamplesSplit;
    private int _minSamplesLeaf;
    private long _seed;
    private byte[] _nominalAttrs;
    private DecisionTree.SplitRule _splitRule;
    private boolean _stratifiedSampling;
    private double _subsample;
    @Nullable
    private double[] _classWeight;
    @Nullable
    private transient Reporter _progressReporter;
    @Nullable
    private transient Counters.Counter _treeBuildTaskCounter;

    @Override
    protected Options getOptions() {
        Options opts = new Options();
        opts.addOption("trees", "num_trees", true, "The number of trees for each task [default: 50]");
        opts.addOption("vars", "num_variables", true, "The number of random selected features [default: ceil(sqrt(x[0].length))]. int(num_variables * x[0].length) is considered if num_variable is (0.0,1.0]");
        opts.addOption("depth", "max_depth", true, "The maximum number of the tree depth [default: Integer.MAX_VALUE]");
        opts.addOption("leafs", "max_leaf_nodes", true, "The maximum number of leaf nodes [default: Integer.MAX_VALUE]");
        opts.addOption("splits", "min_split", true, "A node that has greater than or equals to `min_split` examples will split [default: 2]");
        opts.addOption("min_samples_leaf", true, "The minimum number of samples in a leaf node [default: 1]");
        opts.addOption("seed", true, "seed value in long [default: -1 (random)]");
        opts.addOption("attrs", "attribute_types", true, "Comma separated attribute types (Q for quantitative variable and C for categorical variable. e.g., [Q,C,Q,C])");
        opts.addOption("nominal_attr_indicies", "categorical_attr_indicies", true, "Comma seperated indicies of categorical attributes, e.g., [3,5,6]. Attribute index start with zero.");
        opts.addOption("rule", "split_rule", true, "Split algorithm [default: GINI, ENTROPY, CLASSIFICATION_ERROR]");
        opts.addOption("stratified", "stratified_sampling", false, "Enable Stratified sampling for unbalanced data");
        opts.addOption("subsample", true, "Sampling rate in range (0.0,1.0]. [default: 1.0]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        int trees = 50;
        int maxDepth = Integer.MAX_VALUE;
        int maxLeafNodes = Integer.MAX_VALUE;
        int minSamplesSplit = 2;
        int minSamplesLeaf = 1;
        float numVars = -1.0f;
        RoaringBitmap attrs = new RoaringBitmap();
        long seed = -1L;
        DecisionTree.SplitRule splitRule = DecisionTree.SplitRule.GINI;
        double[] classWeight = null;
        boolean stratifiedSampling = false;
        double subsample = 1.0;
        CommandLine cl = null;
        if (argOIs.length >= 3) {
            String rawArgs = HiveUtils.getConstString(argOIs, 2);
            cl = this.parseOptions(rawArgs);
            trees = Primitives.parseInt(cl.getOptionValue("num_trees"), trees);
            if (trees < 1) {
                throw new IllegalArgumentException("Invalid number of trees: " + trees);
            }
            numVars = Primitives.parseFloat(cl.getOptionValue("num_variables"), numVars);
            maxDepth = Primitives.parseInt(cl.getOptionValue("max_depth"), maxDepth);
            maxLeafNodes = Primitives.parseInt(cl.getOptionValue("max_leaf_nodes"), maxLeafNodes);
            String min_samples_split = cl.getOptionValue("min_samples_split");
            minSamplesSplit = min_samples_split == null ? Primitives.parseInt(cl.getOptionValue("min_split"), minSamplesSplit) : Integer.parseInt(min_samples_split);
            minSamplesLeaf = Primitives.parseInt(cl.getOptionValue("min_samples_leaf"), minSamplesLeaf);
            seed = Primitives.parseLong(cl.getOptionValue("seed"), seed);
            String nominal_attr_indicies = cl.getOptionValue("nominal_attr_indicies");
            attrs = nominal_attr_indicies != null ? SmileExtUtils.parseNominalAttributeIndicies(nominal_attr_indicies) : SmileExtUtils.resolveAttributes(cl.getOptionValue("attribute_types"));
            splitRule = SmileExtUtils.resolveSplitRule(cl.getOptionValue("split_rule", "GINI"));
            stratifiedSampling = cl.hasOption("stratified_sampling");
            subsample = Primitives.parseDouble(cl.getOptionValue("subsample"), 1.0);
            Preconditions.checkArgument(subsample > 0.0 && subsample <= 1.0, UDFArgumentException.class, (Object)("Invalid -subsample value: " + subsample));
            if (argOIs.length >= 4 && (classWeight = HiveUtils.getConstDoubleArray(argOIs[3])) != null) {
                for (int i = 0; i < classWeight.length; ++i) {
                    double v = classWeight[i];
                    if (Double.isNaN(v)) {
                        classWeight[i] = 1.0;
                        continue;
                    }
                    if (!(v <= 0.0)) continue;
                    throw new UDFArgumentTypeException(3, "each classWeight must be greater than 0: " + Arrays.toString(classWeight));
                }
            }
        }
        this._numTrees = trees;
        this._numVars = numVars;
        this._maxDepth = maxDepth;
        this._maxLeafNodes = maxLeafNodes;
        this._minSamplesSplit = minSamplesSplit;
        this._minSamplesLeaf = minSamplesLeaf;
        this._seed = seed;
        this._nominalAttrs = SerdeUtils.serializeRoaring(attrs);
        this._splitRule = splitRule;
        this._stratifiedSampling = stratifiedSampling;
        this._subsample = subsample;
        this._classWeight = classWeight;
        return cl;
    }

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length < 2 || argOIs.length > 4) {
            throw new UDFArgumentException("_FUNC_ takes 2 ~ 4 arguments: array<double|string> features, int label [, const string options, const array<double> classWeight]: " + argOIs.length);
        }
        ListObjectInspector listOI = HiveUtils.asListOI(argOIs, 0);
        ObjectInspector elemOI = listOI.getListElementObjectInspector();
        this.featureListOI = listOI;
        if (HiveUtils.isNumberOI(elemOI)) {
            this.featureElemOI = HiveUtils.asDoubleCompatibleOI(elemOI);
            this.denseInput = true;
            this.matrixBuilder = new RowMajorDenseMatrixBuilder(8192);
        } else if (HiveUtils.isStringOI(elemOI)) {
            this.featureElemOI = HiveUtils.asStringOI(elemOI);
            this.denseInput = false;
            this.matrixBuilder = new CSRMatrixBuilder(8192);
        } else {
            throw new UDFArgumentException("_FUNC_ takes double[] or string[] for the first argument: " + listOI.getTypeName());
        }
        this.labelOI = HiveUtils.asIntCompatibleOI(argOIs, 1);
        this.processOptions(argOIs);
        this.labels = new IntArrayList(1024);
        ArrayList<String> fieldNames = new ArrayList<String>(6);
        ArrayList<Object> fieldOIs = new ArrayList<Object>(6);
        fieldNames.add("model_id");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        fieldNames.add("model_weight");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        fieldNames.add("model");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        fieldNames.add("var_importance");
        if (this.denseInput) {
            fieldOIs.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector));
        } else {
            fieldOIs.add(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector));
        }
        fieldNames.add("oob_errors");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        fieldNames.add("oob_tests");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        if (args[0] == null) {
            throw new HiveException("array<double> features was null");
        }
        this.parseFeatures(args[0], this.matrixBuilder);
        int label = PrimitiveObjectInspectorUtils.getInt((Object)args[1], (PrimitiveObjectInspector)this.labelOI);
        this.labels.add(label);
    }

    private void parseFeatures(@Nonnull Object argObj, @Nonnull MatrixBuilder builder) {
        if (this.denseInput) {
            int length = this.featureListOI.getListLength(argObj);
            for (int i = 0; i < length; ++i) {
                Object o = this.featureListOI.getListElement(argObj, i);
                if (o == null) continue;
                double v = PrimitiveObjectInspectorUtils.getDouble((Object)o, (PrimitiveObjectInspector)this.featureElemOI);
                builder.nextColumn(i, v);
            }
        } else {
            int length = this.featureListOI.getListLength(argObj);
            for (int i = 0; i < length; ++i) {
                Object o = this.featureListOI.getListElement(argObj, i);
                if (o == null) continue;
                String fv = o.toString();
                builder.nextColumn(fv);
            }
        }
        builder.nextRow();
    }

    public void close() throws HiveException {
        this._progressReporter = this.getReporter();
        this._treeBuildTaskCounter = this._progressReporter == null ? null : this._progressReporter.getCounter("hivemall.smile.RandomForestClassifier$Counter", "finishedTreeBuildTasks");
        RandomForestClassifierUDTF.reportProgress(this._progressReporter);
        if (!this.labels.isEmpty()) {
            Matrix x = this.matrixBuilder.buildMatrix();
            this.matrixBuilder = null;
            int[] y = this.labels.toArray();
            this.labels = null;
            if (x.numColumns() == 0) {
                throw new HiveException("No non-null features in the training examples. Revise training data");
            }
            if (x.numRows() != y.length) {
                throw new HiveException("Illegal condition was met. y.length=" + y.length + ", X.length=" + x.numRows());
            }
            this.train(x, y);
        }
        this.featureListOI = null;
        this.featureElemOI = null;
        this.labelOI = null;
    }

    private void checkOptions() throws HiveException {
        if (this._minSamplesSplit <= 0) {
            throw new HiveException("Invalid minSamplesSplit: " + this._minSamplesSplit);
        }
        if (this._maxDepth < 1) {
            throw new HiveException("Invalid maxDepth: " + this._maxDepth);
        }
    }

    private void train(@Nonnull Matrix x, @Nonnull int[] y) throws HiveException {
        int numExamples = x.numRows();
        if (numExamples != y.length) {
            throw new HiveException(String.format("The sizes of X and Y don't match: %d != %d", numExamples, y.length));
        }
        this.checkOptions();
        x = SmileExtUtils.shuffle(x, y, this._seed);
        int[] labels = SmileExtUtils.classLabels(y);
        int numInputVars = SmileExtUtils.computeNumInputVars(this._numVars, x);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("numTrees: " + this._numTrees + ", numVars: " + numInputVars + ", maxDepth: " + this._maxDepth + ", minSamplesSplit: " + this._minSamplesSplit + ", maxLeafs: " + this._maxLeafNodes + ", splitRule: " + (Object)((Object)this._splitRule) + ", seed: " + this._seed));
        }
        RoaringBitmap nominalAttrs = SerdeUtils.deserializeRoaring(this._nominalAttrs);
        this._nominalAttrs = null;
        DoKIntMatrix prediction = new DoKIntMatrix(numExamples, labels.length);
        AtomicInteger remainingTasks = new AtomicInteger(this._numTrees);
        ArrayList<TrainingTask> tasks = new ArrayList<TrainingTask>();
        for (int i = 0; i < this._numTrees; ++i) {
            long s = this._seed == -1L ? -1L : this._seed + (long)i;
            tasks.add(new TrainingTask(this, i, nominalAttrs, x, y, numInputVars, prediction, s, remainingTasks));
        }
        MapredContext mapredContext = MapredContextAccessor.get();
        SmileTaskExecutor executor = new SmileTaskExecutor(mapredContext);
        try {
            executor.run(tasks);
        }
        catch (Exception ex) {
            throw new HiveException((Throwable)ex);
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void forward(int taskId, @Nonnull Text model, @Nonnull Vector importance, @Nonnegative double accuracy, int[] y, @Nonnull IntMatrix prediction, boolean lastTask) throws HiveException {
        int oobErrors = 0;
        int oobTests = 0;
        if (lastTask) {
            for (int i = 0; i < y.length; ++i) {
                int pred = MatrixUtils.whichMax(prediction, i);
                if (pred == -1 || prediction.get(i, pred) <= 0) continue;
                ++oobTests;
                if (pred == y[i]) continue;
                ++oobErrors;
            }
        }
        Object[] forwardObjs = new Object[6];
        String modelId = RandomUtils.getUUID();
        forwardObjs[0] = new Text(modelId);
        forwardObjs[1] = new DoubleWritable(accuracy);
        forwardObjs[2] = model;
        if (this.denseInput) {
            forwardObjs[3] = WritableUtils.toWritableList(importance.toArray());
        } else {
            final HashMap map = new HashMap(importance.size());
            importance.each(new VectorProcedure(){

                @Override
                public void apply(int i, double value) {
                    map.put(new IntWritable(i), new DoubleWritable(value));
                }
            });
            forwardObjs[3] = map;
        }
        forwardObjs[4] = new IntWritable(oobErrors);
        forwardObjs[5] = new IntWritable(oobTests);
        RandomForestClassifierUDTF randomForestClassifierUDTF = this;
        synchronized (randomForestClassifierUDTF) {
            this.forward(forwardObjs);
        }
        RandomForestClassifierUDTF.reportProgress(this._progressReporter);
        RandomForestClassifierUDTF.incrCounter(this._treeBuildTaskCounter, 1L);
        logger.info((Object)("Forwarded " + taskId + "-th DecisionTree out of " + this._numTrees));
    }

    private static final class TrainingTask
    implements Callable<Integer> {
        @Nonnull
        private final RoaringBitmap _nominalAttrs;
        @Nonnull
        private final Matrix _x;
        @Nonnull
        private final int[] _y;
        private final int _numVars;
        @Nonnull
        @GuardedBy(value="_udtf")
        private final IntMatrix _prediction;
        @Nonnull
        private final RandomForestClassifierUDTF _udtf;
        private final int _taskId;
        private final long _seed;
        @Nonnull
        private final AtomicInteger _remainingTasks;

        TrainingTask(@Nonnull RandomForestClassifierUDTF udtf, int taskId, @Nonnull RoaringBitmap nominalAttrs, @Nonnull Matrix x, @Nonnull int[] y, int numVars, @Nonnull IntMatrix prediction, long seed, @Nonnull AtomicInteger remainingTasks) {
            this._udtf = udtf;
            this._taskId = taskId;
            this._nominalAttrs = nominalAttrs;
            this._x = x;
            this._y = y;
            this._numVars = numVars;
            this._prediction = prediction;
            this._seed = seed;
            this._remainingTasks = remainingTasks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer call() throws HiveException {
            long s = this._seed == -1L ? SmileExtUtils.generateSeed() : RandomNumberGeneratorFactory.createPRNG(this._seed).nextLong();
            PRNG rnd1 = RandomNumberGeneratorFactory.createPRNG(s);
            PRNG rnd2 = RandomNumberGeneratorFactory.createPRNG(rnd1.nextLong());
            int N = this._x.numRows();
            int[] samples = this.sampling(N, rnd1);
            DecisionTree tree = new DecisionTree(this._nominalAttrs, this._x, this._y, this._numVars, this._udtf._maxDepth, this._udtf._maxLeafNodes, this._udtf._minSamplesSplit, this._udtf._minSamplesLeaf, samples, this._udtf._splitRule, rnd2);
            int oob = 0;
            int correct = 0;
            Vector xProbe = this._x.rowVector();
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] != 0) continue;
                ++oob;
                this._x.getRow(i, xProbe);
                int p = tree.predict(xProbe);
                if (p == this._y[i]) {
                    ++correct;
                }
                RandomForestClassifierUDTF randomForestClassifierUDTF = this._udtf;
                synchronized (randomForestClassifierUDTF) {
                    this._prediction.incr(i, p);
                    continue;
                }
            }
            Text model = TrainingTask.getModel(tree);
            Vector importance = tree.importance();
            double accuracy = oob == 0 ? 1.0 : (double)correct / (double)oob;
            int remain = this._remainingTasks.decrementAndGet();
            boolean lastTask = remain == 0;
            this._udtf.forward(this._taskId + 1, model, importance, accuracy, this._y, this._prediction, lastTask);
            return remain;
        }

        @Nonnull
        private int[] sampling(int N, @Nonnull PRNG rnd) {
            return this._udtf._stratifiedSampling ? this.stratifiedSampling(N, this._udtf._subsample, rnd) : TrainingTask.uniformSampling(N, this._udtf._subsample, rnd);
        }

        @Nonnull
        private static int[] uniformSampling(int N, double subsample, PRNG rnd) {
            int size = (int)java.lang.Math.round((double)N * subsample);
            int[] samples = new int[N];
            for (int i = 0; i < size; ++i) {
                int index;
                int n = index = rnd.nextInt(N);
                samples[n] = samples[n] + 1;
            }
            return samples;
        }

        @Nonnull
        private int[] stratifiedSampling(int N, double subsample, PRNG rnd) {
            int[] samples = new int[N];
            int k = Math.max(this._y) + 1;
            IntArrayList cj = new IntArrayList(N / k);
            for (int l = 0; l < k; ++l) {
                int nj = 0;
                for (int i = 0; i < N; ++i) {
                    if (this._y[i] != l) continue;
                    cj.add(i);
                    ++nj;
                }
                if (subsample != 1.0) {
                    nj = (int)java.lang.Math.round((double)nj * subsample);
                }
                int size = this._udtf._classWeight == null ? nj : (int)java.lang.Math.round((double)nj * this._udtf._classWeight[l]);
                for (int j = 0; j < size; ++j) {
                    int index;
                    int xi = rnd.nextInt(nj);
                    int n = index = cj.get(xi);
                    samples[n] = samples[n] + 1;
                }
                cj.clear();
            }
            return samples;
        }

        @Nonnull
        private static Text getModel(@Nonnull DecisionTree tree) throws HiveException {
            byte[] b = tree.serialize(true);
            b = Base91.encode(b);
            return new Text(b);
        }
    }
}

