/*
 * Decompiled with CFR 0.152.
 */
package hivemall.smile.tools;

import hivemall.utils.hadoop.HiveUtils;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="guess_attribute_types", value="_FUNC_(ANY, ...) - Returns attribute types", extended="select guess_attribute_types(*) from train limit 1;\n Q,Q,C,C,C,C,Q,C,C,C,Q,C,Q,Q,Q,Q,C,Q")
@UDFType(deterministic=true, stateful=false)
public final class GuessAttributesUDF
extends GenericUDF {
    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        StringBuilder buf = new StringBuilder(128);
        int numArgs = argOIs.length;
        int last = numArgs - 1;
        for (int i = 0; i < numArgs; ++i) {
            if (HiveUtils.isNumberOI(argOIs[i])) {
                buf.append('Q');
            } else {
                buf.append('C');
            }
            if (i == last) continue;
            buf.append(',');
        }
        String value = buf.toString();
        return ObjectInspectorUtils.getConstantObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (Object)value);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        throw new HiveException("GuessAttributesUDF#evaluation should not be called");
    }

    public String getDisplayString(String[] children) {
        return "guess_attribute_types(" + Arrays.toString(children) + ')';
    }
}

