/*
 * Decompiled with CFR 0.152.
 */
package hivemall.smile.tools;

import hivemall.annotations.VisibleForTesting;
import hivemall.smile.vm.StackMachine;
import hivemall.smile.vm.VMRuntimeException;
import hivemall.utils.codec.Base91;
import hivemall.utils.codec.DeflateCodec;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.io.IOUtils;
import hivemall.utils.lang.ObjectUtils;
import java.io.Closeable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;

@Description(name="tree_predict_v1", value="_FUNC_(string modelId, int modelType, string script, array<double> features [, const boolean classification]) - Returns a prediction result of a random forest")
@UDFType(deterministic=true, stateful=false)
@Deprecated
public final class TreePredictUDFv1
extends GenericUDF {
    private boolean classification;
    private PrimitiveObjectInspector modelTypeOI;
    private StringObjectInspector stringOI;
    private ListObjectInspector featureListOI;
    private PrimitiveObjectInspector featureElemOI;
    @Nullable
    private transient Evaluator evaluator;
    private boolean support_javascript_eval = true;

    public void configure(MapredContext context) {
        JobConf conf;
        String tdJarVersion;
        super.configure(context);
        if (context != null && (tdJarVersion = (conf = context.getJobConf()).get("td.jar.version")) != null) {
            this.support_javascript_eval = false;
        }
    }

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        ListObjectInspector listOI;
        if (argOIs.length != 4 && argOIs.length != 5) {
            throw new UDFArgumentException("tree_predict_v1 takes 4 or 5 arguments");
        }
        this.modelTypeOI = HiveUtils.asIntegerOI(argOIs, 1);
        this.stringOI = HiveUtils.asStringOI(argOIs, 2);
        this.featureListOI = listOI = HiveUtils.asListOI(argOIs, 3);
        ObjectInspector elemOI = listOI.getListElementObjectInspector();
        this.featureElemOI = HiveUtils.asDoubleCompatibleOI(elemOI);
        boolean classification = false;
        if (argOIs.length == 5) {
            classification = HiveUtils.getConstBoolean(argOIs, 4);
        }
        this.classification = classification;
        if (classification) {
            return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        }
        return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
    }

    public Writable evaluate(@Nonnull GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object arg0 = arguments[0].get();
        if (arg0 == null) {
            throw new HiveException("ModelId was null");
        }
        String modelId = arg0.toString();
        Object arg1 = arguments[1].get();
        int modelTypeId = PrimitiveObjectInspectorUtils.getInt((Object)arg1, (PrimitiveObjectInspector)this.modelTypeOI);
        ModelType modelType = ModelType.resolve(modelTypeId);
        Object arg2 = arguments[2].get();
        if (arg2 == null) {
            return null;
        }
        Text script = this.stringOI.getPrimitiveWritableObject(arg2);
        Object arg3 = arguments[3].get();
        if (arg3 == null) {
            throw new HiveException("array<double> features was null");
        }
        double[] features = HiveUtils.asDoubleArray(arg3, this.featureListOI, this.featureElemOI);
        if (this.evaluator == null) {
            this.evaluator = TreePredictUDFv1.getEvaluator(modelType, this.support_javascript_eval);
        }
        Writable result = this.evaluator.evaluate(modelId, modelType.isCompressed(), script, features, this.classification);
        return result;
    }

    @Nonnull
    private static Evaluator getEvaluator(@Nonnull ModelType type, boolean supportJavascriptEval) throws UDFArgumentException {
        Evaluator evaluator;
        switch (type) {
            case serialization: 
            case serialization_compressed: {
                evaluator = new JavaSerializationEvaluator();
                break;
            }
            case opscode: 
            case opscode_compressed: {
                evaluator = new StackmachineEvaluator();
                break;
            }
            case javascript: 
            case javascript_compressed: {
                if (!supportJavascriptEval) {
                    throw new UDFArgumentException("Javascript evaluation is not allowed in Treasure Data env");
                }
                evaluator = new JavascriptEvaluator();
                break;
            }
            default: {
                throw new UDFArgumentException("Unexpected model type was detected: " + (Object)((Object)type));
            }
        }
        return evaluator;
    }

    public void close() throws IOException {
        this.modelTypeOI = null;
        this.stringOI = null;
        this.featureElemOI = null;
        this.featureListOI = null;
        IOUtils.closeQuietly((Closeable)this.evaluator);
        this.evaluator = null;
    }

    public String getDisplayString(String[] children) {
        return "tree_predict(" + Arrays.toString(children) + ")";
    }

    static final class JavascriptEvaluator
    implements Evaluator {
        private final ScriptEngine scriptEngine;
        private final Compilable compilableEngine;
        private String prevModelId = null;
        private CompiledScript prevCompiled;
        private DeflateCodec codec = null;

        JavascriptEvaluator() throws UDFArgumentException {
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByExtension("js");
            if (!(engine instanceof Compilable)) {
                throw new UDFArgumentException("ScriptEngine was not compilable: " + engine.getFactory().getEngineName() + " version " + engine.getFactory().getEngineVersion());
            }
            this.scriptEngine = engine;
            this.compilableEngine = (Compilable)((Object)engine);
        }

        @Override
        public Writable evaluate(@Nonnull String modelId, boolean compressed, @Nonnull Text script, double[] features, boolean classification) throws HiveException {
            Object result;
            CompiledScript compiled;
            String scriptStr;
            if (compressed) {
                if (this.codec == null) {
                    this.codec = new DeflateCodec(false, true);
                }
                byte[] b = script.getBytes();
                int len = script.getLength();
                b = Base91.decode(b, 0, len);
                try {
                    b = this.codec.decompress(b);
                }
                catch (IOException e) {
                    throw new HiveException("decompression failed", (Throwable)e);
                }
                scriptStr = new String(b);
            } else {
                scriptStr = script.toString();
            }
            if (modelId.equals(this.prevModelId)) {
                compiled = this.prevCompiled;
            } else {
                try {
                    compiled = this.compilableEngine.compile(scriptStr);
                }
                catch (ScriptException e) {
                    throw new HiveException("failed to compile: \n" + script, (Throwable)e);
                }
                this.prevCompiled = compiled;
            }
            Bindings bindings = this.scriptEngine.createBindings();
            try {
                bindings.put("x", (Object)features);
                result = compiled.eval(bindings);
            }
            catch (ScriptException se) {
                throw new HiveException("failed to evaluate: \n" + script, (Throwable)se);
            }
            catch (Throwable e) {
                throw new HiveException("failed to evaluate: \n" + script, e);
            }
            finally {
                bindings.clear();
            }
            if (result == null) {
                return null;
            }
            if (!(result instanceof Number)) {
                throw new HiveException("Got an unexpected non-number result: " + result);
            }
            if (classification) {
                Number casted = (Number)result;
                return new IntWritable(casted.intValue());
            }
            Number casted = (Number)result;
            return new DoubleWritable(casted.doubleValue());
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeQuietly((Closeable)this.codec);
        }
    }

    static final class StackmachineEvaluator
    implements Evaluator {
        private String prevModelId = null;
        private StackMachine prevVM = null;
        private DeflateCodec codec = null;

        StackmachineEvaluator() {
        }

        @Override
        public Writable evaluate(@Nonnull String modelId, boolean compressed, @Nonnull Text script, double[] features, boolean classification) throws HiveException {
            StackMachine vm;
            String scriptStr;
            if (compressed) {
                if (this.codec == null) {
                    this.codec = new DeflateCodec(false, true);
                }
                byte[] b = script.getBytes();
                int len = script.getLength();
                b = Base91.decode(b, 0, len);
                try {
                    b = this.codec.decompress(b);
                }
                catch (IOException e) {
                    throw new HiveException("decompression failed", (Throwable)e);
                }
                scriptStr = new String(b);
            } else {
                scriptStr = script.toString();
            }
            if (modelId.equals(this.prevModelId)) {
                vm = this.prevVM;
            } else {
                vm = new StackMachine();
                try {
                    vm.compile(scriptStr);
                }
                catch (VMRuntimeException e) {
                    throw new HiveException("failed to compile StackMachine", (Throwable)e);
                }
                this.prevModelId = modelId;
                this.prevVM = vm;
            }
            try {
                vm.eval(features);
            }
            catch (VMRuntimeException vme) {
                throw new HiveException("failed to eval StackMachine", (Throwable)vme);
            }
            catch (Throwable e) {
                throw new HiveException("failed to eval StackMachine", e);
            }
            Double result = vm.getResult();
            if (result == null) {
                return null;
            }
            if (classification) {
                return new IntWritable(result.intValue());
            }
            return new DoubleWritable(result.doubleValue());
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeQuietly((Closeable)this.codec);
        }
    }

    static final class RtNodeV1
    implements Externalizable {
        double output = 0.0;
        int splitFeature = -1;
        boolean quantitativeFeature = true;
        double splitValue = Double.NaN;
        double splitScore = 0.0;
        RtNodeV1 trueChild;
        RtNodeV1 falseChild;
        double trueChildOutput = 0.0;
        double falseChildOutput = 0.0;

        RtNodeV1() {
        }

        RtNodeV1(double output) {
            this.output = output;
        }

        double predict(double[] x) {
            if (this.trueChild == null && this.falseChild == null) {
                return this.output;
            }
            if (this.quantitativeFeature) {
                if (x[this.splitFeature] <= this.splitValue) {
                    return this.trueChild.predict(x);
                }
                return this.falseChild.predict(x);
            }
            if (x[this.splitFeature] == this.splitValue) {
                return this.trueChild.predict(x);
            }
            return this.falseChild.predict(x);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.output = in.readDouble();
            this.splitFeature = in.readInt();
            int typeId = in.readInt();
            this.quantitativeFeature = typeId == 1;
            this.splitValue = in.readDouble();
            if (in.readBoolean()) {
                this.trueChild = new RtNodeV1();
                this.trueChild.readExternal(in);
            }
            if (in.readBoolean()) {
                this.falseChild = new RtNodeV1();
                this.falseChild.readExternal(in);
            }
        }
    }

    static final class DtNodeV1
    implements Externalizable {
        int output = -1;
        int splitFeature = -1;
        boolean quantitativeFeature = true;
        double splitValue = Double.NaN;
        double splitScore = 0.0;
        DtNodeV1 trueChild = null;
        DtNodeV1 falseChild = null;
        int trueChildOutput = -1;
        int falseChildOutput = -1;

        DtNodeV1() {
        }

        DtNodeV1(int output) {
            this.output = output;
        }

        int predict(double[] x) {
            if (this.trueChild == null && this.falseChild == null) {
                return this.output;
            }
            if (this.quantitativeFeature) {
                if (x[this.splitFeature] <= this.splitValue) {
                    return this.trueChild.predict(x);
                }
                return this.falseChild.predict(x);
            }
            if (x[this.splitFeature] == this.splitValue) {
                return this.trueChild.predict(x);
            }
            return this.falseChild.predict(x);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.output = in.readInt();
            this.splitFeature = in.readInt();
            int typeId = in.readInt();
            this.quantitativeFeature = typeId == 1;
            this.splitValue = in.readDouble();
            if (in.readBoolean()) {
                this.trueChild = new DtNodeV1();
                this.trueChild.readExternal(in);
            }
            if (in.readBoolean()) {
                this.falseChild = new DtNodeV1();
                this.falseChild.readExternal(in);
            }
        }
    }

    static final class JavaSerializationEvaluator
    implements Evaluator {
        @Nullable
        private String prevModelId = null;
        private DtNodeV1 cNode = null;
        private RtNodeV1 rNode = null;

        JavaSerializationEvaluator() {
        }

        @Override
        public Writable evaluate(@Nonnull String modelId, boolean compressed, @Nonnull Text script, double[] features, boolean classification) throws HiveException {
            if (classification) {
                return this.evaluateClassification(modelId, compressed, script, features);
            }
            return this.evaluateRegression(modelId, compressed, script, features);
        }

        private IntWritable evaluateClassification(@Nonnull String modelId, boolean compressed, @Nonnull Text script, double[] features) throws HiveException {
            if (!modelId.equals(this.prevModelId)) {
                this.prevModelId = modelId;
                int length = script.getLength();
                byte[] b = script.getBytes();
                b = Base91.decode(b, 0, length);
                this.cNode = JavaSerializationEvaluator.deserializeDecisionTree(b, b.length, compressed);
            }
            assert (this.cNode != null);
            int result = this.cNode.predict(features);
            return new IntWritable(result);
        }

        @Nonnull
        @VisibleForTesting
        static DtNodeV1 deserializeDecisionTree(@Nonnull byte[] serializedObj, int length, boolean compressed) throws HiveException {
            DtNodeV1 root = new DtNodeV1();
            try {
                if (compressed) {
                    ObjectUtils.readCompressedObject(serializedObj, 0, length, root);
                } else {
                    ObjectUtils.readObject(serializedObj, length, root);
                }
            }
            catch (IOException ioe) {
                throw new HiveException("IOException cause while deserializing DecisionTree object", (Throwable)ioe);
            }
            catch (Exception e) {
                throw new HiveException("Exception cause while deserializing DecisionTree object", (Throwable)e);
            }
            return root;
        }

        private DoubleWritable evaluateRegression(@Nonnull String modelId, boolean compressed, @Nonnull Text script, double[] features) throws HiveException {
            if (!modelId.equals(this.prevModelId)) {
                this.prevModelId = modelId;
                int length = script.getLength();
                byte[] b = script.getBytes();
                b = Base91.decode(b, 0, length);
                this.rNode = JavaSerializationEvaluator.deserializeRegressionTree(b, b.length, compressed);
            }
            assert (this.rNode != null);
            double result = this.rNode.predict(features);
            return new DoubleWritable(result);
        }

        @Nonnull
        @VisibleForTesting
        static RtNodeV1 deserializeRegressionTree(byte[] serializedObj, int length, boolean compressed) throws HiveException {
            RtNodeV1 root = new RtNodeV1();
            try {
                if (compressed) {
                    ObjectUtils.readCompressedObject(serializedObj, 0, length, root);
                } else {
                    ObjectUtils.readObject(serializedObj, length, root);
                }
            }
            catch (IOException ioe) {
                throw new HiveException("IOException cause while deserializing DecisionTree object", (Throwable)ioe);
            }
            catch (Exception e) {
                throw new HiveException("Exception cause while deserializing DecisionTree object", (Throwable)e);
            }
            return root;
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static interface Evaluator
    extends Closeable {
        @Nullable
        public Writable evaluate(@Nonnull String var1, boolean var2, @Nonnull Text var3, @Nonnull double[] var4, boolean var5) throws HiveException;
    }

    static enum ModelType {
        opscode(1, false),
        javascript(2, false),
        serialization(3, false),
        opscode_compressed(-1, true),
        javascript_compressed(-2, true),
        serialization_compressed(-3, true);

        private final int id;
        private final boolean compressed;

        private ModelType(int id, boolean compressed) {
            this.id = id;
            this.compressed = compressed;
        }

        int getId() {
            return this.id;
        }

        boolean isCompressed() {
            return this.compressed;
        }

        @Nonnull
        static ModelType resolve(int id) {
            ModelType type;
            switch (id) {
                case 1: {
                    type = opscode;
                    break;
                }
                case -1: {
                    type = opscode_compressed;
                    break;
                }
                case 2: {
                    type = javascript;
                    break;
                }
                case -2: {
                    type = javascript_compressed;
                    break;
                }
                case 3: {
                    type = serialization;
                    break;
                }
                case -3: {
                    type = serialization_compressed;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected ID for ModelType: " + id);
                }
            }
            return type;
        }
    }
}

