/*
 * Decompiled with CFR 0.152.
 */
package hivemall.smile.utils;

import hivemall.utils.concurrent.ExecutorFactory;
import hivemall.utils.lang.Primitives;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.mapred.JobConf;

public final class SmileTaskExecutor {
    private static final Log logger = LogFactory.getLog(SmileTaskExecutor.class);
    @Nullable
    private final ExecutorService exec;

    public SmileTaskExecutor(@Nullable MapredContext mapredContext) {
        JobConf conf;
        int nprocs = Runtime.getRuntime().availableProcessors();
        int threads = Math.max(1, nprocs - 1);
        if (mapredContext != null && (conf = mapredContext.getJobConf()) != null) {
            String tdJarVersion = conf.get("td.jar.version");
            if (tdJarVersion == null) {
                String hivemallNprocs = conf.get("hivemall.smile.nprocs");
                threads = Primitives.parseInt(hivemallNprocs, threads);
            } else {
                String tdHivemallNprocs = conf.get("td.hivemall.smile.nprocs");
                threads = Primitives.parseInt(tdHivemallNprocs, 1);
            }
        }
        if (threads > 1) {
            logger.info((Object)("Initialized FixedThreadPool of " + threads + " threads"));
            this.exec = ExecutorFactory.newFixedThreadPool(threads, "Hivemall-SMILE", true);
        } else {
            logger.info((Object)"Direct execution in a caller thread is selected");
            this.exec = null;
        }
    }

    public <T> List<T> run(Collection<? extends Callable<T>> tasks) throws Exception {
        ArrayList results = new ArrayList(tasks.size());
        if (this.exec == null) {
            for (Callable<T> task : tasks) {
                results.add(task.call());
            }
        } else {
            List futures = this.exec.invokeAll(tasks);
            for (Future future : futures) {
                results.add(future.get());
            }
        }
        return results;
    }

    public void shutdown() {
        if (this.exec != null) {
            this.exec.shutdownNow();
        }
    }
}

