/*
 * Decompiled with CFR 0.152.
 */
package hivemall.smile.utils;

import hivemall.utils.collections.arrays.SparseIntArray;
import hivemall.utils.function.Consumer;
import javax.annotation.Nonnull;

public final class VariableOrder {
    @Nonnull
    private final SparseIntArray[] cols;

    public VariableOrder(@Nonnull SparseIntArray[] cols) {
        this.cols = cols;
    }

    public void eachRow(@Nonnull Consumer consumer) {
        for (int j = 0; j < this.cols.length; ++j) {
            SparseIntArray row = this.cols[j];
            if (row == null) continue;
            consumer.accept(j, row);
        }
    }

    public void eachNonNullInColumn(int col, int startRow, int endRow, @Nonnull Consumer consumer) {
        SparseIntArray row = this.cols[col];
        if (row == null) {
            return;
        }
        row.forEach(startRow, endRow, consumer);
    }
}

