/*
 * Decompiled with CFR 0.152.
 */
package hivemall.smile.vm;

import hivemall.smile.vm.Operation;
import hivemall.smile.vm.VMRuntimeException;
import hivemall.utils.lang.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import smile.math.Math;

@Deprecated
public final class StackMachine {
    public static final String SEP = "; ";
    @Nonnull
    private final List<Operation> code = new ArrayList<Operation>();
    @Nonnull
    private final Map<String, Double> valuesMap = new HashMap<String, Double>();
    @Nonnull
    private final Map<String, Integer> jumpMap = new HashMap<String, Integer>();
    @Nonnull
    private final Stack<Double> programStack = new Stack();
    private int IP;
    private int SP = 0;
    private int codeLength;
    private boolean[] done;
    private Double result = null;

    public void run(@Nonnull String scripts, @Nonnull double[] features) throws VMRuntimeException {
        this.compile(scripts);
        this.eval(features);
    }

    public void run(@Nonnull List<String> opslist, @Nonnull double[] features) throws VMRuntimeException {
        this.compile(opslist);
        this.eval(features);
    }

    public void compile(@Nonnull String scripts) throws VMRuntimeException {
        List<String> opslist = Arrays.asList(scripts.split(SEP));
        this.compile(opslist);
    }

    public void compile(@Nonnull List<String> opslist) throws VMRuntimeException {
        for (String line : opslist) {
            Operation.OperationEnum o;
            String[] ops = line.split(" ", -1);
            if (ops.length == 2) {
                o = Operation.OperationEnum.valueOfLowerCase(ops[0]);
                this.code.add(new Operation(o, ops[1]));
                continue;
            }
            o = Operation.OperationEnum.valueOfLowerCase(ops[0]);
            this.code.add(new Operation(o));
        }
        int size = opslist.size();
        this.codeLength = size - 1;
        this.done = new boolean[size];
    }

    public void eval(double[] features) throws VMRuntimeException {
        this.init();
        this.bind(features);
        this.execute(0);
    }

    private void init() {
        this.valuesMap.clear();
        this.jumpMap.clear();
        this.programStack.clear();
        this.SP = 0;
        this.result = null;
        Arrays.fill(this.done, false);
    }

    private void bind(double[] features) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < features.length; ++i) {
            String bindKey = buf.append("x[").append(i).append("]").toString();
            this.valuesMap.put(bindKey, features[i]);
            StringUtils.clear(buf);
        }
    }

    private void execute(int entryPoint) throws VMRuntimeException {
        this.valuesMap.put("end", -1.0);
        this.jumpMap.put("last", this.codeLength);
        this.IP = entryPoint;
        while (this.IP < this.code.size()) {
            if (this.done[this.IP]) {
                throw new VMRuntimeException("There is a infinite loop in the Machine code.");
            }
            this.done[this.IP] = true;
            Operation currentOperation = this.code.get(this.IP);
            if (this.executeOperation(currentOperation)) continue;
            return;
        }
    }

    @Nullable
    public Double getResult() {
        return this.result;
    }

    private Double pop() {
        --this.SP;
        return this.programStack.pop();
    }

    private Double push(Double val) {
        this.programStack.push(val);
        ++this.SP;
        return val;
    }

    private boolean executeOperation(Operation currentOperation) throws VMRuntimeException {
        if (this.IP < 0) {
            return false;
        }
        switch (currentOperation.op) {
            case GOTO: {
                if (StringUtils.isInt(currentOperation.operand)) {
                    this.IP = Integer.parseInt(currentOperation.operand);
                    break;
                }
                this.IP = this.jumpMap.get(currentOperation.operand);
                break;
            }
            case CALL: {
                double candidateIP = this.valuesMap.get(currentOperation.operand);
                if (!(candidateIP < 0.0)) break;
                this.evaluateBuiltinByName(currentOperation.operand);
                ++this.IP;
                break;
            }
            case IFEQ: {
                double a = this.pop();
                double b = this.pop();
                if (a == b) {
                    ++this.IP;
                    break;
                }
                if (StringUtils.isInt(currentOperation.operand)) {
                    this.IP = Integer.parseInt(currentOperation.operand);
                    break;
                }
                this.IP = this.jumpMap.get(currentOperation.operand);
                break;
            }
            case IFEQ2: {
                double a = this.pop();
                double b = this.pop();
                if (Math.equals(a, b)) {
                    ++this.IP;
                    break;
                }
                if (StringUtils.isInt(currentOperation.operand)) {
                    this.IP = Integer.parseInt(currentOperation.operand);
                    break;
                }
                this.IP = this.jumpMap.get(currentOperation.operand);
                break;
            }
            case IFGE: {
                double lower = this.pop();
                double upper = this.pop();
                if (upper >= lower) {
                    ++this.IP;
                    break;
                }
                if (StringUtils.isInt(currentOperation.operand)) {
                    this.IP = Integer.parseInt(currentOperation.operand);
                    break;
                }
                this.IP = this.jumpMap.get(currentOperation.operand);
                break;
            }
            case IFGT: {
                double lower = this.pop();
                double upper = this.pop();
                if (upper > lower) {
                    ++this.IP;
                    break;
                }
                if (StringUtils.isInt(currentOperation.operand)) {
                    this.IP = Integer.parseInt(currentOperation.operand);
                    break;
                }
                this.IP = this.jumpMap.get(currentOperation.operand);
                break;
            }
            case IFLE: {
                double lower = this.pop();
                double upper = this.pop();
                if (upper <= lower) {
                    ++this.IP;
                    break;
                }
                if (StringUtils.isInt(currentOperation.operand)) {
                    this.IP = Integer.parseInt(currentOperation.operand);
                    break;
                }
                this.IP = this.jumpMap.get(currentOperation.operand);
                break;
            }
            case IFLT: {
                double lower = this.pop();
                double upper = this.pop();
                if (upper < lower) {
                    ++this.IP;
                    break;
                }
                if (StringUtils.isInt(currentOperation.operand)) {
                    this.IP = Integer.parseInt(currentOperation.operand);
                    break;
                }
                this.IP = this.jumpMap.get(currentOperation.operand);
                break;
            }
            case POP: {
                this.valuesMap.put(currentOperation.operand, this.pop());
                ++this.IP;
                break;
            }
            case PUSH: {
                if (StringUtils.isDouble(currentOperation.operand)) {
                    this.push(Double.parseDouble(currentOperation.operand));
                } else {
                    Double v = this.valuesMap.get(currentOperation.operand);
                    if (v == null) {
                        throw new VMRuntimeException("value is not bound: " + currentOperation.operand);
                    }
                    this.push(v);
                }
                ++this.IP;
                break;
            }
            default: {
                throw new VMRuntimeException("Machine code has wrong opcode :" + (Object)((Object)currentOperation.op));
            }
        }
        return true;
    }

    private void evaluateBuiltinByName(String name) throws VMRuntimeException {
        if (!name.equals("end")) {
            throw new VMRuntimeException("Machine code has wrong built-in function :" + name);
        }
        this.result = this.pop();
    }
}

