/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.IntWritable;

@Description(name="convert_label", value="_FUNC_(const int|const float) - Convert from -1|1 to 0.0f|1.0f, or from 0.0f|1.0f to -1|1")
@UDFType(deterministic=true, stateful=false)
public final class ConvertLabelUDF
extends UDF {
    public IntWritable evaluate(int label) throws UDFArgumentException {
        if (label == 0) {
            return new IntWritable(-1);
        }
        if (label == -1) {
            return new IntWritable(0);
        }
        if (label == 1) {
            return new IntWritable(1);
        }
        throw new UDFArgumentException("-1 or 1 or 0 is expected. Unexpected label: " + label);
    }

    public IntWritable evaluate(float label) throws UDFArgumentException {
        if (label == 0.0f) {
            return new IntWritable(-1);
        }
        if (label == -1.0f) {
            return new IntWritable(0);
        }
        if (label == 1.0f) {
            return new IntWritable(1);
        }
        throw new UDFArgumentException("-1 or 1 or 0 is expected. Unexpected label: " + label);
    }

    public IntWritable evaluate(double label) throws UDFArgumentException {
        if (label == 0.0) {
            return new IntWritable(-1);
        }
        if (label == -1.0) {
            return new IntWritable(0);
        }
        if (label == 1.0) {
            return new IntWritable(1);
        }
        throw new UDFArgumentException("-1 or 1 or 0 is expected. Unexpected label: " + label);
    }
}

