/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools;

import hivemall.utils.hadoop.HiveUtils;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

@Description(name="generate_series", value="_FUNC_(const int|bigint start, const int|bigint end) - Generate a series of values, from start to end. A similar function to PostgreSQL's [generate_serics](https://www.postgresql.org/docs/current/static/functions-srf.html)", extended="SELECT generate_series(2,4);\n\n 2\n 3\n 4\n\nSELECT generate_series(5,1,-2);\n\n 5\n 3\n 1\n\nSELECT generate_series(4,3);\n\n (no return)\n\nSELECT date_add(current_date(),value),value from (SELECT generate_series(1,3)) t;\n\n 2018-04-21      1\n 2018-04-22      2\n 2018-04-23      3\n\nWITH input as (\n SELECT 1 as c1, 10 as c2, 3 as step\n UNION ALL\n SELECT 10, 2, -3\n)\nSELECT generate_series(c1, c2, step) as series\nFROM input;\n\n 1\n 4\n 7\n 10\n 10\n 7\n 4")
public final class GenerateSeriesUDTF
extends GenericUDTF {
    private PrimitiveObjectInspector startOI;
    private PrimitiveObjectInspector endOI;
    @Nullable
    private PrimitiveObjectInspector stepOI;
    @Nonnull
    private final Writable[] row = new Writable[1];
    private boolean returnLong;

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2 && argOIs.length != 3) {
            throw new UDFArgumentException("Expected number of arguments is 2 or 3: " + argOIs.length);
        }
        this.startOI = HiveUtils.asIntegerOI(argOIs, 0);
        this.endOI = HiveUtils.asIntegerOI(argOIs, 1);
        if (argOIs.length == 3) {
            this.stepOI = HiveUtils.asIntegerOI(argOIs, 2);
        }
        this.returnLong = HiveUtils.isBigIntOI((ObjectInspector)this.startOI) || HiveUtils.isBigIntOI((ObjectInspector)this.endOI);
        ArrayList<String> fieldNames = new ArrayList<String>(1);
        fieldNames.add("value");
        ArrayList<Object> fieldOIs = new ArrayList<Object>(1);
        if (this.returnLong) {
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
        } else {
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        if (this.returnLong) {
            this.generateLongSeries(args);
        } else {
            this.generateIntSeries(args);
        }
    }

    private void generateLongSeries(@Nonnull Object[] args) throws HiveException {
        long end;
        long step = 1L;
        switch (args.length) {
            case 3: {
                step = PrimitiveObjectInspectorUtils.getLong((Object)args[2], (PrimitiveObjectInspector)this.stepOI);
                if (step == 0L) {
                    throw new UDFArgumentException("Step MUST NOT be zero");
                }
            }
            case 2: {
                long start2 = PrimitiveObjectInspectorUtils.getLong((Object)args[0], (PrimitiveObjectInspector)this.startOI);
                end = PrimitiveObjectInspectorUtils.getLong((Object)args[1], (PrimitiveObjectInspector)this.endOI);
                break;
            }
            default: {
                throw new UDFArgumentException("Expected number of arguments: " + args.length);
            }
        }
        LongWritable row0 = new LongWritable();
        this.row[0] = row0;
        if (step > 0L) {
            for (long i = start2; i <= end; i += step) {
                row0.set(i);
                this.forward(this.row);
            }
        } else {
            for (long i = start2; i >= end; i += step) {
                row0.set(i);
                this.forward(this.row);
            }
        }
    }

    private void generateIntSeries(@Nonnull Object[] args) throws HiveException {
        int end;
        int step = 1;
        switch (args.length) {
            case 3: {
                step = PrimitiveObjectInspectorUtils.getInt((Object)args[2], (PrimitiveObjectInspector)this.stepOI);
                if (step == 0) {
                    throw new UDFArgumentException("Step MUST NOT be zero");
                }
            }
            case 2: {
                int start2 = PrimitiveObjectInspectorUtils.getInt((Object)args[0], (PrimitiveObjectInspector)this.startOI);
                end = PrimitiveObjectInspectorUtils.getInt((Object)args[1], (PrimitiveObjectInspector)this.endOI);
                break;
            }
            default: {
                throw new UDFArgumentException("Expected number of arguments: " + args.length);
            }
        }
        IntWritable row0 = new IntWritable();
        this.row[0] = row0;
        if (step > 0) {
            for (int i = start2; i <= end; i += step) {
                row0.set(i);
                this.forward(this.row);
            }
        } else {
            for (int i = start2; i >= end; i += step) {
                row0.set(i);
                this.forward(this.row);
            }
        }
    }

    public void close() throws HiveException {
    }
}

