/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.LongWritable;

@Description(name="x_rank", value="_FUNC_(KEY) - Generates a pseudo sequence number starting from 1 for each key")
@UDFType(deterministic=false, stateful=true)
public final class RankSequenceUDF
extends UDF {
    private final LongWritable counter = new LongWritable(0L);
    private boolean lastNull = false;
    private String lastKey = null;

    @Nonnull
    public LongWritable evaluate(@Nullable String key) {
        if (key == null) {
            if (this.lastNull) {
                this.counter.set(this.counter.get() + 1L);
            } else {
                this.counter.set(1L);
                this.lastNull = true;
            }
        } else {
            if (key.equals(this.lastKey)) {
                this.counter.set(this.counter.get() + 1L);
            } else {
                this.counter.set(1L);
                this.lastKey = key;
            }
            this.lastNull = false;
        }
        return this.counter;
    }
}

