/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools;

import hivemall.utils.hadoop.HiveUtils;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="try_cast", value="_FUNC_(ANY src, const string typeName) - Explicitly cast a value as a type. Returns null if cast fails.", extended="SELECT try_cast(array(1.0,2.0,3.0), 'array<string>')\nSELECT try_cast(map('A',10,'B',20,'C',30), 'map<string,double>')")
@UDFType(deterministic=true, stateful=false)
public final class TryCastUDF
extends GenericUDF {
    private ObjectInspector inputOI;
    private ObjectInspectorConverters.Converter converter;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentException("try_cast(ANY src, const string typeName) expects exactly two arguments");
        }
        this.inputOI = argOIs[0];
        String typeString = HiveUtils.getConstString(argOIs, 1);
        ObjectInspector outputOI = HiveUtils.getObjectInspector(typeString, true);
        this.converter = ObjectInspectorConverters.getConverter((ObjectInspector)this.inputOI, (ObjectInspector)outputOI);
        return outputOI;
    }

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        Object arg0 = args[0].get();
        if (arg0 == null) {
            return null;
        }
        Object input = ObjectInspectorUtils.copyToStandardObject((Object)arg0, (ObjectInspector)this.inputOI);
        try {
            return this.converter.convert(input);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getDisplayString(String[] args) {
        return "try_cast(" + Arrays.toString(args) + ")";
    }
}

