/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.aggr;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.LongCounter;
import hivemall.utils.lang.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="majority_vote", value="_FUNC_(Primitive x) - Returns the most frequent value of x", extended="-- see https://issues.apache.org/jira/browse/HIVE-17406 \nWITH data as (\n  select\n    explode(array('1', '2', '2', '2', '5', '4', '1', '2')) as k\n)\nselect\n  majority_vote(k) as k\nfrom \n  data;\n2")
public final class MajorityVoteUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(@Nonnull TypeInfo[] argTypes) throws SemanticException {
        if (argTypes.length != 1) {
            throw new UDFArgumentLengthException("Expected ecactly one argument: " + argTypes.length);
        }
        if (!HiveUtils.isPrimitiveTypeInfo(argTypes[0])) {
            throw new UDFArgumentTypeException(0, "PRIMITIVE type is expected but got " + argTypes[0]);
        }
        return new Evaluator();
    }

    @GenericUDAFEvaluator.AggregationType(estimable=true)
    public static final class CounterBuffer
    extends GenericUDAFEvaluator.AbstractAggregationBuffer {
        @Nonnull
        private LongCounter<Object> partial;

        public CounterBuffer() {
            this.reset();
        }

        void reset() {
            this.partial = new LongCounter();
        }

        void iterate(@Nonnull Object k) {
            this.partial.increment(k);
        }

        void merge(@Nonnull Object k, long v) {
            this.partial.increment(k, v);
        }

        @Nonnull
        Map<Object, Long> terminatePartial() {
            return this.partial.getMap();
        }

        @Nullable
        Object terminate() {
            return this.partial.whichMax();
        }

        public int estimate() {
            int size = this.partial.size();
            return 8 * size * 2;
        }
    }

    public static final class Evaluator
    extends GenericUDAFEvaluator {
        private transient PrimitiveObjectInspector keyInputOI;
        private transient PrimitiveObjectInspector keyOutputOI;
        private transient StandardMapObjectInspector partialOI;
        private transient LongObjectInspector counterInputOI;

        public ObjectInspector init(@Nonnull GenericUDAFEvaluator.Mode mode, @Nonnull ObjectInspector[] argOIs) throws HiveException {
            assert (argOIs.length == 1);
            super.init(mode, argOIs);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.keyInputOI = HiveUtils.asPrimitiveObjectInspector(argOIs[0]);
            } else {
                this.partialOI = (StandardMapObjectInspector)argOIs[0];
                this.keyInputOI = HiveUtils.asPrimitiveObjectInspector(this.partialOI.getMapKeyObjectInspector());
                this.counterInputOI = HiveUtils.asLongOI(this.partialOI.getMapValueObjectInspector());
            }
            this.keyOutputOI = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)this.keyInputOI.getTypeInfo());
            Object outputOI = mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2 ? ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)this.keyOutputOI, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector) : this.keyOutputOI;
            return outputOI;
        }

        public CounterBuffer getNewAggregationBuffer() throws HiveException {
            CounterBuffer buf = new CounterBuffer();
            buf.reset();
            return buf;
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            CounterBuffer buf = (CounterBuffer)agg;
            buf.reset();
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            CounterBuffer buf = (CounterBuffer)agg;
            Object param0 = parameters[0];
            if (param0 == null) {
                return;
            }
            Object key = this.keyInputOI.getPrimitiveJavaObject(param0);
            if (key != null) {
                buf.iterate(key);
            }
        }

        public Map<Object, Long> terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            CounterBuffer buf = (CounterBuffer)agg;
            return buf.terminatePartial();
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial == null) {
                return;
            }
            CounterBuffer buf = (CounterBuffer)agg;
            Map partialResult = this.partialOI.getMap(partial);
            for (Map.Entry e : partialResult.entrySet()) {
                Object k = this.keyInputOI.getPrimitiveJavaObject(Preconditions.checkNotNull(e.getKey()));
                long v = this.counterInputOI.get(Preconditions.checkNotNull(e.getValue()));
                buf.merge(k, v);
            }
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            CounterBuffer buf = (CounterBuffer)agg;
            return buf.terminate();
        }
    }
}

