/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.aggr;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

@Description(name="min_by", value="_FUNC_(x, y) - Returns the value of x associated with the minimum value of y over all input values.", extended="-- see https://issues.apache.org/jira/browse/HIVE-17406 \nWITH data as (\n  select 'jake' as name, 18 as age\n  union all\n  select 'tom' as name, 64 as age\n  union all\n  select 'lisa' as name, 32 as age\n)\nselect\n  min_by(name, age) as name\nfrom\n  data;\n\njake")
public final class MinByUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(@Nonnull TypeInfo[] argTypes) throws SemanticException {
        if (argTypes.length != 2) {
            throw new UDFArgumentLengthException("Exactly two arguments are expected: " + argTypes.length);
        }
        ObjectInspector yOI = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)argTypes[1]);
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)yOI)) {
            throw new UDFArgumentTypeException(1, "Cannot support comparison of map<> type or complex type containing map<>.");
        }
        return new Evaluator();
    }

    @UDFType(distinctLike=true)
    public static class Evaluator
    extends GenericUDAFEvaluator {
        private transient ObjectInspector xInputOI;
        private transient ObjectInspector yInputOI;
        private transient ObjectInspector xOutputOI;
        private transient ObjectInspector yOutputOI;
        @Nullable
        private transient StructField xField;
        @Nullable
        private transient StructField yField;
        @Nullable
        private transient StructObjectInspector partialInputOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] argOIs) throws HiveException {
            super.init(mode, argOIs);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.xInputOI = argOIs[0];
                this.yInputOI = argOIs[1];
                if (!ObjectInspectorUtils.compareSupported((ObjectInspector)this.yInputOI)) {
                    throw new UDFArgumentTypeException(1, "Cannot support comparison of map<> type or complex type containing map<>.");
                }
            } else {
                this.partialInputOI = (StructObjectInspector)argOIs[0];
                this.xField = this.partialInputOI.getStructFieldRef("x");
                this.xInputOI = this.xField.getFieldObjectInspector();
                this.yField = this.partialInputOI.getStructFieldRef("y");
                this.yInputOI = this.yField.getFieldObjectInspector();
            }
            this.xOutputOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.xInputOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            this.yOutputOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.yInputOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<String> fieldNames = new ArrayList<String>(2);
                ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>(2);
                fieldNames.add("x");
                fieldOIs.add(this.xOutputOI);
                fieldNames.add("y");
                fieldOIs.add(this.yOutputOI);
                return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
            }
            ObjectInspector outputOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.xInputOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            return outputOI;
        }

        public MinAgg getNewAggregationBuffer() throws HiveException {
            return new MinAgg();
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MinAgg myagg = (MinAgg)agg;
            myagg.x = null;
            myagg.y = null;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            assert (parameters.length == 2);
            MinAgg myagg = (MinAgg)agg;
            Object x = parameters[0];
            Object y = parameters[1];
            myagg.merge(x, y, this.xInputOI, this.yInputOI, this.yOutputOI);
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MinAgg myagg = (MinAgg)agg;
            Object[] partial = new Object[]{myagg.x, myagg.y};
            return partial;
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial == null) {
                return;
            }
            MinAgg myagg = (MinAgg)agg;
            Object x = this.partialInputOI.getStructFieldData(partial, this.xField);
            Object y = this.partialInputOI.getStructFieldData(partial, this.yField);
            myagg.merge(x, y, this.xInputOI, this.yInputOI, this.yOutputOI);
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MinAgg myagg = (MinAgg)agg;
            return myagg.x;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=false)
        static class MinAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            Object x;
            Object y;

            MinAgg() {
            }

            public int estimate() {
                return 16;
            }

            void merge(Object newX, Object newY, @Nonnull ObjectInspector xInputOI, @Nonnull ObjectInspector yInputOI, @Nonnull ObjectInspector yOutputOI) {
                int cmp = ObjectInspectorUtils.compare((Object)this.y, (ObjectInspector)yOutputOI, (Object)newY, (ObjectInspector)yInputOI);
                if (this.x == null || cmp > 0) {
                    this.x = ObjectInspectorUtils.copyToStandardObject((Object)newX, (ObjectInspector)xInputOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
                    this.y = ObjectInspectorUtils.copyToStandardObject((Object)newY, (ObjectInspector)yInputOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
                }
            }
        }
    }
}

