/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.ArrayUtils;
import hivemall.utils.lang.StringUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.IntWritable;

@Description(name="arange", value="_FUNC_([int start=0, ] int stop, [int step=1]) - Return evenly spaced values within a given interval", extended="SELECT arange(5), arange(1, 5), arange(1, 5, 1), arange(0, 5, 1);\n> [0,1,2,3,4]     [1,2,3,4]       [1,2,3,4]       [0,1,2,3,4]\n\nSELECT arange(1, 6, 2);\n> 1, 3, 5\n\nSELECT arange(-1, -6, 2);\n-1, -3, -5")
@UDFType(deterministic=true, stateful=false)
public final class ArangeUDF
extends GenericUDF {
    @Nullable
    private PrimitiveObjectInspector startOI;
    private PrimitiveObjectInspector stopOI;
    @Nullable
    private PrimitiveObjectInspector stepOI;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        switch (argOIs.length) {
            case 1: {
                if (!HiveUtils.isIntegerOI(argOIs[0])) {
                    throw new UDFArgumentException("arange(int stop) expects integer for the 1st argument: " + argOIs[0].getTypeName());
                }
                this.stopOI = HiveUtils.asIntegerOI(argOIs[0]);
                break;
            }
            case 3: {
                if (!HiveUtils.isIntegerOI(argOIs[2])) {
                    throw new UDFArgumentException("arange(int start, int stop, int step) expects integer for the 3rd argument: " + argOIs[2].getTypeName());
                }
                this.stepOI = HiveUtils.asIntegerOI(argOIs[2]);
            }
            case 2: {
                if (!HiveUtils.isIntegerOI(argOIs[0])) {
                    throw new UDFArgumentException("arange(int start, int stop) expects integer for the 1st argument: " + argOIs[0].getTypeName());
                }
                this.startOI = HiveUtils.asIntegerOI(argOIs[0]);
                if (!HiveUtils.isIntegerOI(argOIs[1])) {
                    throw new UDFArgumentException("arange(int start, int stop) expects integer for the 2nd argument: " + argOIs[1].getTypeName());
                }
                this.stopOI = HiveUtils.asIntegerOI(argOIs[1]);
                break;
            }
            default: {
                throw new UDFArgumentException("arange([int start=0, ] int stop, [int step=1]) takes 1~3 arguments: " + argOIs.length);
            }
        }
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector));
    }

    @Nullable
    public List<IntWritable> evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int stop;
        int start2 = 0;
        int step = 1;
        switch (arguments.length) {
            case 1: {
                Object arg0 = arguments[0].get();
                if (arg0 == null) {
                    return null;
                }
                stop = PrimitiveObjectInspectorUtils.getInt((Object)arg0, (PrimitiveObjectInspector)this.stopOI);
                break;
            }
            case 3: {
                Object arg2 = arguments[2].get();
                if (arg2 == null) {
                    return null;
                }
                step = PrimitiveObjectInspectorUtils.getInt((Object)arg2, (PrimitiveObjectInspector)this.stepOI);
            }
            case 2: {
                Object arg0 = arguments[0].get();
                if (arg0 == null) {
                    return null;
                }
                start2 = PrimitiveObjectInspectorUtils.getInt((Object)arg0, (PrimitiveObjectInspector)this.startOI);
                Object arg1 = arguments[1].get();
                if (arg1 == null) {
                    return null;
                }
                stop = PrimitiveObjectInspectorUtils.getInt((Object)arg1, (PrimitiveObjectInspector)this.stopOI);
                break;
            }
            default: {
                throw new UDFArgumentException("arange([int start=0, ] int stop, [int step=1]) takes 1~3 arguments: " + arguments.length);
            }
        }
        return Arrays.asList(ArangeUDF.range(start2, stop, step));
    }

    private static IntWritable[] range(int start2, int stop, @Nonnegative int step) throws UDFArgumentException {
        IntWritable[] r;
        if (step <= 0) {
            throw new UDFArgumentException("Invalid step value: " + step);
        }
        int diff = stop - start2;
        if (diff < 0) {
            int count = ArrayUtils.divideAndRoundUp(-diff, step);
            r = new IntWritable[count];
            int i = 0;
            int value = start2;
            while (i < r.length) {
                r[i] = new IntWritable(value);
                ++i;
                value -= step;
            }
        } else {
            int count = ArrayUtils.divideAndRoundUp(diff, step);
            r = new IntWritable[count];
            int i = 0;
            int value = start2;
            while (i < r.length) {
                r[i] = new IntWritable(value);
                ++i;
                value += step;
            }
        }
        return r;
    }

    public String getDisplayString(String[] children) {
        return "arange(" + StringUtils.join(children, ',') + ')';
    }
}

