/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;

@Description(name="argmin", value="_FUNC_(array<T> a) - Returns the first index of the minimum value", extended="SELECT argmin(array(5,2,0,1));\n2")
@UDFType(deterministic=true, stateful=false)
public final class ArgminUDF
extends GenericUDF {
    private ListObjectInspector listOI;
    private PrimitiveObjectInspector elemOI;
    private IntWritable result;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 1) {
            throw new UDFArgumentException("argmin takes exactly one argument: " + argOIs.length);
        }
        this.listOI = HiveUtils.asListOI(argOIs[0]);
        this.elemOI = HiveUtils.asPrimitiveObjectInspector(this.listOI.getListElementObjectInspector());
        this.result = new IntWritable();
        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
    }

    public IntWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object arg0 = arguments[0].get();
        if (arg0 == null) {
            return null;
        }
        int index = -1;
        Object minObject = null;
        int size = this.listOI.getListLength(arg0);
        for (int i = 0; i < size; ++i) {
            Object ai = this.listOI.getListElement(arg0, i);
            if (ai == null) continue;
            if (minObject == null) {
                minObject = ai;
                index = i;
                continue;
            }
            int cmp = ObjectInspectorUtils.compare((Object)ai, (ObjectInspector)this.elemOI, (Object)minObject, (ObjectInspector)this.elemOI);
            if (cmp >= 0) continue;
            minObject = ai;
            index = i;
        }
        this.result.set(index);
        return this.result;
    }

    public String getDisplayString(String[] children) {
        return "argmin(" + StringUtils.join(children, ',') + ')';
    }
}

