/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.hadoop.HiveUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;

@Description(name="argsort", value="_FUNC_(array<ANY> a) - Returns the indices that would sort an array.", extended="SELECT argsort(array(5,2,0,1));\n2, 3, 1, 0\n\nSELECT array_slice(array(5,2,0,1), argsort(array(5,2,0,1)));\n0, 1, 2, 5")
@UDFType(deterministic=true, stateful=false)
public final class ArgsortUDF
extends GenericUDF {
    private ListObjectInspector listOI;
    private ObjectInspector elemOI;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 1) {
            throw new UDFArgumentLengthException("argsort(array<ANY> a) takes exactly 1 argument: " + argOIs.length);
        }
        ObjectInspector argOI0 = argOIs[0];
        if (argOI0.getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("argsort(array<ANY> a) expects array<ANY> for the first argument: " + argOI0.getTypeName());
        }
        this.listOI = HiveUtils.asListOI(argOI0);
        this.elemOI = this.listOI.getListElementObjectInspector();
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
    }

    @Nullable
    public List<IntWritable> evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        final Object arg0 = arguments[0].get();
        if (arg0 == null) {
            return null;
        }
        int size = this.listOI.getListLength(arg0);
        Integer[] indexes = new Integer[size];
        for (int i = 0; i < size; ++i) {
            indexes[i] = i;
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer i, Integer j) {
                Object ei = ArgsortUDF.this.listOI.getListElement(arg0, i.intValue());
                Object ej = ArgsortUDF.this.listOI.getListElement(arg0, j.intValue());
                return ObjectInspectorUtils.compare((Object)ei, (ObjectInspector)ArgsortUDF.this.elemOI, (Object)ej, (ObjectInspector)ArgsortUDF.this.elemOI);
            }
        });
        IntWritable[] ret = new IntWritable[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = new IntWritable(indexes[i].intValue());
        }
        return Arrays.asList(ret);
    }

    public String getDisplayString(String[] children) {
        return "argsort(" + StringUtils.join((Object[])children, (char)',') + ')';
    }
}

