/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.hadoop.HiveUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

@Description(name="array_append", value="_FUNC_(array<T> arr, T elem) - Append an element to the end of an array", extended="SELECT array_append(array(1,2),3);\n 1,2,3\n\nSELECT array_append(array('a','b'),'c');\n \"a\",\"b\",\"c\"")
@UDFType(deterministic=true, stateful=false)
public final class ArrayAppendUDF
extends GenericUDF {
    private ListObjectInspector listInspector;
    private PrimitiveObjectInspector listElemInspector;
    private PrimitiveObjectInspector primInspector;
    private boolean returnWritables;
    private final List<Object> ret = new ArrayList<Object>();

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        this.listInspector = HiveUtils.asListOI(argOIs[0]);
        this.listElemInspector = HiveUtils.asPrimitiveObjectInspector(this.listInspector.getListElementObjectInspector());
        this.primInspector = HiveUtils.asPrimitiveObjectInspector(argOIs[1]);
        if (this.listElemInspector.getPrimitiveCategory() != this.primInspector.getPrimitiveCategory()) {
            throw new UDFArgumentException("array_append expects the list type to match the type of the value being appended");
        }
        this.returnWritables = this.listElemInspector.preferWritable();
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.listElemInspector));
    }

    @Nullable
    public List<Object> evaluate(@Nonnull GenericUDF.DeferredObject[] args) throws HiveException {
        this.ret.clear();
        Object arg0 = args[0].get();
        if (arg0 == null) {
            Object arg1 = args[1].get();
            if (arg1 != null) {
                Object toAppend = this.returnWritables ? this.primInspector.getPrimitiveWritableObject(arg1) : this.primInspector.getPrimitiveJavaObject(arg1);
                return Arrays.asList(toAppend);
            }
            return null;
        }
        int size = this.listInspector.getListLength(arg0);
        for (int i = 0; i < size; ++i) {
            Object rawElem = this.listInspector.getListElement(arg0, i);
            if (rawElem == null) continue;
            Object obj = this.returnWritables ? this.listElemInspector.getPrimitiveWritableObject(rawElem) : this.listElemInspector.getPrimitiveJavaObject(rawElem);
            this.ret.add(obj);
        }
        Object arg1 = args[1].get();
        if (arg1 != null) {
            Object toAppend = this.returnWritables ? this.primInspector.getPrimitiveWritableObject(arg1) : this.primInspector.getPrimitiveJavaObject(arg1);
            this.ret.add(toAppend);
        }
        return this.ret;
    }

    public String getDisplayString(String[] args) {
        return "array_append(" + args[0] + ", " + args[1] + ")";
    }
}

