/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.hadoop.HiveUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;

@Description(name="element_at", value="_FUNC_(array<T> list, int pos) - Returns an element at the given position", extended="SELECT element_at(array(1,2,3,4),0);\n 1\n\nSELECT element_at(array(1,2,3,4),-2);\n 3")
@UDFType(deterministic=true, stateful=false)
public final class ArrayElementAtUDF
extends GenericUDF {
    private ListObjectInspector listInspector;
    private IntObjectInspector intInspector;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentException("element_at takes an array and an int as arguments");
        }
        this.listInspector = HiveUtils.asListOI(argOIs[0]);
        this.intInspector = HiveUtils.asIntOI(argOIs[1]);
        return this.listInspector.getListElementObjectInspector();
    }

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        Object list = args[0].get();
        if (list == null) {
            return null;
        }
        Object arg1 = args[1].get();
        if (arg1 == null) {
            throw new HiveException("Index MUST not be null");
        }
        int arrayLength = this.listInspector.getListLength(list);
        int idx = this.intInspector.get(arg1);
        if (idx < 0 ? (idx = arrayLength + idx) < 0 : idx >= arrayLength) {
            return null;
        }
        return this.listInspector.getListElement(list, idx);
    }

    public String getDisplayString(String[] args) {
        return "element_at( " + args[0] + " , " + args[1] + " )";
    }
}

