/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="array_flatten", value="_FUNC_(array<array<ANY>>) - Returns an array with the elements flattened.", extended="SELECT array_flatten(array(array(1,2,3),array(4,5),array(6,7,8)));\n [1,2,3,4,5,6,7,8]")
@UDFType(deterministic=true, stateful=false)
public final class ArrayFlattenUDF
extends GenericUDF {
    private ListObjectInspector listOI;
    private final List<Object> result = new ArrayList<Object>();

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 1) {
            throw new UDFArgumentException("array_flatten expects exactly one argument: " + argOIs.length);
        }
        this.listOI = HiveUtils.asListOI(argOIs[0]);
        ObjectInspector listElemOI = this.listOI.getListElementObjectInspector();
        if (listElemOI.getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("array_flatten takes array of array for the argument: " + this.listOI.toString());
        }
        ListObjectInspector nestedListOI = HiveUtils.asListOI(listElemOI);
        ObjectInspector elemOI = nestedListOI.getListElementObjectInspector();
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)elemOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
    }

    public List<Object> evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        this.result.clear();
        Object arg0 = args[0].get();
        if (arg0 == null) {
            return null;
        }
        int listLength = this.listOI.getListLength(arg0);
        for (int i = 0; i < listLength; ++i) {
            Object subarray = this.listOI.getListElement(arg0, i);
            if (subarray == null) continue;
            ListObjectInspector subarrayOI = HiveUtils.asListOI(this.listOI.getListElementObjectInspector());
            ObjectInspector elemOI = subarrayOI.getListElementObjectInspector();
            int subarrayLength = subarrayOI.getListLength(subarray);
            for (int j = 0; j < subarrayLength; ++j) {
                Object rawElem = subarrayOI.getListElement(subarray, j);
                if (rawElem == null) continue;
                Object elem = ObjectInspectorUtils.copyToStandardObject((Object)rawElem, (ObjectInspector)elemOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                this.result.add(elem);
            }
        }
        return this.result;
    }

    public String getDisplayString(String[] args) {
        return "array_flatten(" + StringUtils.join(args, ',') + ")";
    }
}

