/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

@Description(name="array_remove", value="_FUNC_(array<PRIMITIVE> values, PRIMITIVE|array<PRIMITIVE> target) - Returns an array that the target elements are removed from the original array", extended="select array_remove(array(2.0,2.1,3.0,4.0,2.0),2), array_remove(array(2.0,3.0,4.0),array(3,2.0));\n[2.1,3,4]       [4]\n\nSELECT array_remove(array(1,null,3),null);\n[1,3]\n\nSELECT array_remove(array(1,null,3,null,5),null);\n[1,3,5]\n\nSELECT array_remove(array(1,null,3),array(null));\n[1,3]\n\nSELECT array_remove(array('aaa','bbb'),'bbb');\n[\"aaa\"]\n\nSELECT array_remove(array('aaa','bbb','ccc','bbb'), array('bbb','ccc'));\n[\"aaa\"]\n\nselect array_remove(array(null),null);\n[]\n\nselect array_remove(array(null,'bbb'),'aaa');\n[null,\"bbb\"]")
@UDFType(deterministic=true, stateful=false)
public final class ArrayRemoveUDF
extends GenericUDF {
    private ListObjectInspector valueListOI;
    private PrimitiveObjectInspector valueElemOI;
    private boolean isTargetList;
    @Nullable
    private ListObjectInspector targetListOI;
    private PrimitiveObjectInspector targetElemOI;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentLengthException("Expected 2 arguments, but got " + argOIs.length);
        }
        this.valueListOI = HiveUtils.asListOI(argOIs, 0);
        this.valueElemOI = HiveUtils.asPrimitiveObjectInspector(this.valueListOI.getListElementObjectInspector());
        if (HiveUtils.isListOI(argOIs[1])) {
            this.isTargetList = true;
            this.targetListOI = HiveUtils.asListOI(argOIs, 1);
            this.targetElemOI = HiveUtils.asPrimitiveObjectInspector(this.targetListOI.getListElementObjectInspector());
        } else {
            this.isTargetList = false;
            this.targetElemOI = HiveUtils.asPrimitiveObjectInspector(argOIs, 1);
        }
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.valueElemOI);
    }

    @Nullable
    public Object evaluate(@Nonnull GenericUDF.DeferredObject[] arguments) throws HiveException {
        assert (arguments.length == 2);
        ArrayList<Object> values = HiveUtils.copyListObject(arguments[0], this.valueListOI);
        if (values == null) {
            return null;
        }
        Object target = arguments[1].get();
        if (target == null) {
            values.removeAll(Collections.singletonList(null));
            return values;
        }
        if (this.isTargetList) {
            ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter((ObjectInspector)this.targetListOI, (ObjectInspector)this.valueListOI);
            ArrayRemoveUDF.removeAll(values, target, converter, this.valueListOI);
        } else {
            ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter((ObjectInspector)this.targetElemOI, (ObjectInspector)this.valueElemOI);
            ArrayRemoveUDF.removeAll(values, target, converter);
        }
        return values;
    }

    private static void removeAll(@Nonnull List<?> values, @Nonnull Object target, @Nonnull ObjectInspectorConverters.Converter converter, @Nonnull ListObjectInspector valueListOI) {
        Object converted = converter.convert(target);
        List convertedList = valueListOI.getList(converted);
        values.removeAll(convertedList);
    }

    private static void removeAll(@Nonnull List<?> values, @Nonnull Object target, @Nonnull ObjectInspectorConverters.Converter converter) {
        Object converted = converter.convert(target);
        values.removeAll(Collections.singleton(converted));
    }

    public String getDisplayString(String[] children) {
        return "array_remove(" + StringUtils.join(children, ',') + ')';
    }
}

