/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="array_slice", value="_FUNC_(array<ANY> values, int offset [, int length]) - Slices the given array by the given offset and length parameters.", extended="SELECT \n  array_slice(array(1,2,3,4,5,6),2,4),\n  array_slice(\n   array(\"zero\", \"one\", \"two\", \"three\", \"four\", \"five\", \"six\", \"seven\", \"eight\", \"nine\", \"ten\"),\n   0, -- offset\n   2 -- length\n  ),\n  array_slice(\n   array(\"zero\", \"one\", \"two\", \"three\", \"four\", \"five\", \"six\", \"seven\", \"eight\", \"nine\", \"ten\"),\n   6, -- offset\n   3 -- length\n  ),\n  array_slice(\n   array(\"zero\", \"one\", \"two\", \"three\", \"four\", \"five\", \"six\", \"seven\", \"eight\", \"nine\", \"ten\"),\n   6, -- offset\n   10 -- length\n  ),\n  array_slice(\n   array(\"zero\", \"one\", \"two\", \"three\", \"four\", \"five\", \"six\", \"seven\", \"eight\", \"nine\", \"ten\"),\n   6 -- offset\n  ),\n  array_slice(\n   array(\"zero\", \"one\", \"two\", \"three\", \"four\", \"five\", \"six\", \"seven\", \"eight\", \"nine\", \"ten\"),\n   -3 -- offset\n  ),\n  array_slice(\n   array(\"zero\", \"one\", \"two\", \"three\", \"four\", \"five\", \"six\", \"seven\", \"eight\", \"nine\", \"ten\"),\n   -3, -- offset\n   2 -- length\n  );\n\n [3,4]\n [\"zero\",\"one\"] \n [\"six\",\"seven\",\"eight\"]\n [\"six\",\"seven\",\"eight\",\"nine\",\"ten\"]\n [\"six\",\"seven\",\"eight\",\"nine\",\"ten\"]\n [\"eight\",\"nine\",\"ten\"]\n [\"eight\",\"nine\"]")
@UDFType(deterministic=true, stateful=false)
public final class ArraySliceUDF
extends GenericUDF {
    private ListObjectInspector valuesOI;
    private PrimitiveObjectInspector offsetOI;
    @Nullable
    private PrimitiveObjectInspector lengthOI;
    private final List<Object> result = new ArrayList<Object>();

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2 && argOIs.length != 3) {
            throw new UDFArgumentLengthException("Expected 2 or 3 arguments, but got " + argOIs.length);
        }
        this.valuesOI = HiveUtils.asListOI(argOIs[0]);
        this.offsetOI = HiveUtils.asIntegerOI(argOIs[1]);
        if (argOIs.length == 3) {
            this.lengthOI = HiveUtils.asIntegerOI(argOIs[2]);
        }
        ObjectInspector elemOI = this.valuesOI.getListElementObjectInspector();
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)elemOI);
    }

    @Nullable
    public List<Object> evaluate(@Nonnull GenericUDF.DeferredObject[] args) throws HiveException {
        int length;
        Object arg2;
        int fromIndex;
        Object arg0 = args[0].get();
        if (arg0 == null) {
            return null;
        }
        int size = this.valuesOI.getListLength(arg0);
        this.result.clear();
        Object arg1 = args[1].get();
        if (arg1 == null) {
            throw new UDFArgumentException("Offset argument MUST NOT be null");
        }
        int offset = PrimitiveObjectInspectorUtils.getInt((Object)arg1, (PrimitiveObjectInspector)this.offsetOI);
        int n = fromIndex = offset < 0 ? size + offset : offset;
        int toIndex = args.length == 3 ? ((arg2 = args[2].get()) == null ? size : ((length = PrimitiveObjectInspectorUtils.getInt((Object)arg2, (PrimitiveObjectInspector)this.lengthOI)) < 0 ? size + length : Math.min(size, fromIndex + length))) : size;
        if (!ArraySliceUDF.validRange(fromIndex, toIndex, size)) {
            return null;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            Object e = this.valuesOI.getListElement(arg0, i);
            this.result.add(e);
        }
        return this.result;
    }

    private static boolean validRange(int fromIndex, int toIndex, int size) throws HiveException {
        if (fromIndex < 0) {
            return false;
        }
        if (toIndex < 0) {
            return false;
        }
        if (toIndex > size) {
            return false;
        }
        return fromIndex <= toIndex;
    }

    public String getDisplayString(String[] args) {
        return "array_slice(" + StringUtils.join(args, ',') + ")";
    }
}

