/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.hadoop.HiveUtils;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;

@Description(name="array_to_str", value="_FUNC_(array arr [, string sep=',']) - Convert array to string using a sperator", extended="SELECT array_to_str(array(1,2,3),'-');\n1-2-3")
@UDFType(deterministic=true, stateful=false)
public final class ArrayToStrUDF
extends GenericUDF {
    private ListObjectInspector listOI;
    @Nullable
    private StringObjectInspector sepOI;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 1 && argOIs.length != 2) {
            throw new UDFArgumentLengthException("array_to_str(array, string sep) expects one or two arguments: " + argOIs.length);
        }
        this.listOI = HiveUtils.asListOI(argOIs[0]);
        if (argOIs.length == 2) {
            this.sepOI = HiveUtils.asStringOI(argOIs[1]);
        }
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }

    public String evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object arg1;
        Object arg0 = arguments[0].get();
        if (arg0 == null) {
            return null;
        }
        String sep = ",";
        if (arguments.length == 2 && (arg1 = arguments[1].get()) != null) {
            sep = this.sepOI.getPrimitiveJavaObject(arg1);
        }
        StringBuilder buf = new StringBuilder();
        int len = this.listOI.getListLength(arg0);
        for (int i = 0; i < len; ++i) {
            Object e = this.listOI.getListElement(arg0, i);
            if (e == null) continue;
            if (i != 0 && buf.length() > 0) {
                buf.append(sep);
            }
            buf.append(e.toString());
        }
        return buf.toString();
    }

    public String getDisplayString(String[] children) {
        return "array_to_str(" + StringUtils.join((Object[])children, (char)',') + ")";
    }
}

