/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.hadoop.HiveUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="array_union", value="_FUNC_(array1, array2, ...) - Returns the union of a set of arrays", extended="SELECT array_union(array(1,2),array(1,2));\n[1,2]\n\nSELECT array_union(array(1,2),array(2,3),array(2,5));\n[1,2,3,5]")
@UDFType(deterministic=true, stateful=false)
public final class ArrayUnionUDF
extends GenericUDF {
    private ListObjectInspector[] _listOIs;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        ListObjectInspector arg0OI;
        if (argOIs.length < 2) {
            throw new UDFArgumentException("Expecting at least two arrays as arguments");
        }
        ListObjectInspector[] listOIs = new ListObjectInspector[argOIs.length];
        listOIs[0] = arg0OI = HiveUtils.asListOI(argOIs[0]);
        ObjectInspector arg0ElemOI = arg0OI.getListElementObjectInspector();
        for (int i = 1; i < argOIs.length; ++i) {
            ListObjectInspector checkOI = HiveUtils.asListOI(argOIs[i]);
            if (!ObjectInspectorUtils.compareTypes((ObjectInspector)arg0ElemOI, (ObjectInspector)checkOI.getListElementObjectInspector())) {
                throw new UDFArgumentException("Array types does not match: " + arg0OI.getTypeName() + " != " + checkOI.getTypeName());
            }
            listOIs[i] = checkOI;
        }
        this._listOIs = listOIs;
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)arg0ElemOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
    }

    public List<Object> evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        TreeSet<Object> objectSet = new TreeSet<Object>();
        for (int i = 0; i < args.length; ++i) {
            Object undeferred = args[i].get();
            if (undeferred == null) continue;
            ListObjectInspector oi = this._listOIs[i];
            ObjectInspector elemOI = oi.getListElementObjectInspector();
            int len = oi.getListLength(undeferred);
            for (int j = 0; j < len; ++j) {
                Object nonStd = oi.getListElement(undeferred, j);
                Object copyed = ObjectInspectorUtils.copyToStandardObject((Object)nonStd, (ObjectInspector)elemOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                objectSet.add(copyed);
            }
        }
        return new ArrayList<Object>(objectSet);
    }

    public String getDisplayString(String[] args) {
        return "array_union(" + args[0] + ", " + args[1] + " )";
    }
}

