/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.hadoop.HiveUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;

@Description(name="conditional_emit", value="_FUNC_(array<boolean> conditions, array<primitive> features) - Emit features of a row according to various conditions", extended="WITH input as (\n   select array(true, false, true) as conditions, array(\"one\", \"two\", \"three\") as features\n   UNION ALL\n   select array(true, true, false), array(\"four\", \"five\", \"six\")\n)\nSELECT\n  conditional_emit(\n     conditions, features\n  )\nFROM \n  input;\n one\n three\n four\n five")
@UDFType(deterministic=true, stateful=false)
public final class ConditionalEmitUDTF
extends GenericUDTF {
    private ListObjectInspector conditionsOI;
    private BooleanObjectInspector condElemOI;
    private ListObjectInspector featuresOI;
    private PrimitiveObjectInspector featureElemOI;
    private final Object[] forwardObj = new Object[1];

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentException("conditional_emit takes 2 arguments: array<boolean>, array<primitive>");
        }
        this.conditionsOI = HiveUtils.asListOI(argOIs[0]);
        this.condElemOI = HiveUtils.asBooleanOI(this.conditionsOI.getListElementObjectInspector());
        this.featuresOI = HiveUtils.asListOI(argOIs[1]);
        this.featureElemOI = HiveUtils.asPrimitiveObjectInspector(this.featuresOI.getListElementObjectInspector());
        List<String> fieldNames = Arrays.asList("feature");
        List<ObjectInspector> fieldOIs = Arrays.asList(this.featureElemOI);
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(@Nonnull Object[] args) throws HiveException {
        int featureSize;
        Object arg0 = args[0];
        Object arg1 = args[1];
        if (arg0 == null || arg1 == null) {
            return;
        }
        int conditionSize = this.conditionsOI.getListLength(arg0);
        if (conditionSize != (featureSize = this.featuresOI.getListLength(arg1))) {
            throw new HiveException("Arrays must be of same length in condition_emit(array<boolean> conditions, array<string> features).\n#conditions=" + conditionSize + ", #features=" + featureSize);
        }
        for (int i = 0; i < conditionSize; ++i) {
            Object featureObj;
            Object condObj = this.conditionsOI.getListElement(arg0, i);
            if (condObj == null || !this.condElemOI.get(condObj) || (featureObj = this.featuresOI.getListElement(arg1, i)) == null) continue;
            this.forwardObj[0] = featureObj;
            this.forward(this.forwardObj);
        }
    }

    public void close() throws HiveException {
    }
}

