/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.hadoop.HiveUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="last_element", value="_FUNC_(x) - Return the last element in an array", extended="SELECT last_element(array('a','b','c'));\n c")
@UDFType(deterministic=true, stateful=false)
public class LastElementUDF
extends GenericUDF {
    private ListObjectInspector listInspector;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 1) {
            throw new UDFArgumentException("last_element takes an array as an argument");
        }
        this.listInspector = HiveUtils.asListOI(argOIs[0]);
        return this.listInspector.getListElementObjectInspector();
    }

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        Object list = args[0].get();
        if (list == null) {
            return null;
        }
        int lastIdx = this.listInspector.getListLength(list) - 1;
        if (lastIdx >= 0) {
            return this.listInspector.getListElement(list, lastIdx);
        }
        return null;
    }

    public String getDisplayString(String[] args) {
        return "last_element( " + args[0] + " )";
    }
}

