/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="to_string_array", value="_FUNC_(array<ANY>) - Returns an array of strings", extended="select to_string_array(array(1.0,2.0,3.0));\n\n[\"1.0\",\"2.0\",\"3.0\"]")
@UDFType(deterministic=true, stateful=false)
public final class ToStringArrayUDF
extends GenericUDF {
    private ListObjectInspector listOI;
    private List<String> result;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 1) {
            throw new UDFArgumentException("to_string_array expects exactly one argument: " + argOIs.length);
        }
        this.listOI = HiveUtils.asListOI(argOIs[0]);
        this.result = new ArrayList<String>();
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
    }

    public List<String> evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object arg0 = arguments[0].get();
        if (arg0 == null) {
            return null;
        }
        this.result.clear();
        int len = this.listOI.getListLength(arg0);
        for (int i = 0; i < len; ++i) {
            Object e = this.listOI.getListElement(arg0, i);
            if (e == null) {
                this.result.add(null);
                continue;
            }
            this.result.add(e.toString());
        }
        return this.result;
    }

    public String getDisplayString(String[] children) {
        return "to_string_array(" + StringUtils.join(children, ',') + ')';
    }
}

