/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.datetime;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@Description(name="sessionize", value="_FUNC_(long timeInSec, long thresholdInSec [, String subject])- Returns a UUID string of a session.", extended="SELECT \n  sessionize(time, 3600, ip_addr) as session_id, \n  time, ip_addr\nFROM (\n  SELECT time, ipaddr \n  FROM weblog \n  DISTRIBUTE BY ip_addr, time SORT BY ip_addr, time DESC\n) t1")
@UDFType(deterministic=false, stateful=true)
public final class SessionizeUDF
extends UDF {
    private long lastTime;
    @Nullable
    private Text lastSubject;
    @Nonnull
    private final Text sessionId = new Text();

    @Nullable
    public Text evaluate(@Nullable LongWritable time, @Nullable LongWritable threshold) {
        if (time == null || threshold == null) {
            return null;
        }
        long thisTime = time.get();
        long diff = thisTime - this.lastTime;
        if (diff < threshold.get()) {
            this.lastTime = thisTime;
            return this.sessionId;
        }
        this.sessionId.set(UUID.randomUUID().toString());
        this.lastTime = time.get();
        return this.sessionId;
    }

    @Nullable
    public Text evaluate(@Nullable LongWritable time, @Nullable LongWritable threshold, @Nullable Text subject) {
        if (time == null || threshold == null || subject == null) {
            return null;
        }
        if (subject.equals((Object)this.lastSubject)) {
            long thisTime = time.get();
            long diff = thisTime - this.lastTime;
            if (diff < threshold.get()) {
                this.lastTime = thisTime;
                return this.sessionId;
            }
        } else if (this.lastSubject == null) {
            this.lastSubject = new Text(subject);
        } else {
            this.lastSubject.set(subject);
        }
        this.sessionId.set(UUID.randomUUID().toString());
        this.lastTime = time.get();
        return this.sessionId;
    }
}

