/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.json;

import hivemall.hcatalog.data.HCatRecordObjectInspectorFactory;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.hadoop.JsonSerdeUtils;
import hivemall.utils.lang.ArrayUtils;
import hivemall.utils.lang.ExceptionUtils;
import hivemall.utils.lang.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;

@Description(name="from_json", value="_FUNC_(string jsonString, const string returnTypes [, const array<string>|const string columnNames]) - Return Hive object.", extended="SELECT\n  from_json(to_json(map('one',1,'two',2)), 'map<string,int>'),\n  from_json(\n    '{ \"person\" : { \"name\" : \"makoto\" , \"age\" : 37 } }',\n    'struct<name:string,age:int>', \n    array('person')\n  ),\n  from_json(\n    '[0.1,1.1,2.2]',\n    'array<double>'\n  ),\n  from_json(to_json(\n    ARRAY(\n      NAMED_STRUCT(\"country\", \"japan\", \"city\", \"tokyo\"), \n      NAMED_STRUCT(\"country\", \"japan\", \"city\", \"osaka\")\n    )\n  ),'array<struct<country:string,city:string>>'),\n  from_json(to_json(\n    ARRAY(\n      NAMED_STRUCT(\"country\", \"japan\", \"city\", \"tokyo\"), \n      NAMED_STRUCT(\"country\", \"japan\", \"city\", \"osaka\")\n    ),\n    array('city')\n  ), 'array<struct<country:string,city:string>>'),\n  from_json(to_json(\n    ARRAY(\n      NAMED_STRUCT(\"country\", \"japan\", \"city\", \"tokyo\"), \n      NAMED_STRUCT(\"country\", \"japan\", \"city\", \"osaka\")\n    )\n  ),'array<struct<city:string>>');\n```\n\n```\n {\"one\":1,\"two\":2}\n {\"name\":\"makoto\",\"age\":37}\n [0.1,1.1,2.2]\n [{\"country\":\"japan\",\"city\":\"tokyo\"},{\"country\":\"japan\",\"city\":\"osaka\"}]\n [{\"country\":\"japan\",\"city\":\"tokyo\"},{\"country\":\"japan\",\"city\":\"osaka\"}]\n [{\"city\":\"tokyo\"},{\"city\":\"osaka\"}]")
@UDFType(deterministic=true, stateful=false)
public final class FromJsonUDF
extends GenericUDF {
    private StringObjectInspector jsonOI;
    private List<TypeInfo> columnTypes;
    @Nullable
    private List<String> columnNames;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2 && argOIs.length != 3) {
            throw new UDFArgumentException("from_json takes two or three arguments: " + argOIs.length);
        }
        this.jsonOI = HiveUtils.asStringOI(argOIs[0]);
        String typeString = HiveUtils.getConstString(argOIs[1]);
        this.columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)typeString);
        if (argOIs.length == 3) {
            ObjectInspector argOI2 = argOIs[2];
            if (HiveUtils.isConstString(argOI2)) {
                String names = HiveUtils.getConstString(argOI2);
                this.columnNames = ArrayUtils.asKryoSerializableList(names.split(","));
            } else if (HiveUtils.isConstStringListOI(argOI2)) {
                this.columnNames = ArrayUtils.asKryoSerializableList(HiveUtils.getConstStringArray(argOI2));
            } else {
                throw new UDFArgumentException("Expected `const array<string>` or `const string` but got an unexpected OI type for the third argument: " + argOI2);
            }
        }
        return FromJsonUDF.getObjectInspector(this.columnTypes, this.columnNames);
    }

    @Nonnull
    private static ObjectInspector getObjectInspector(@Nonnull List<TypeInfo> columnTypes, @Nullable List<String> columnNames) throws UDFArgumentException {
        ObjectInspector returnOI;
        if (columnTypes.isEmpty()) {
            throw new UDFArgumentException("Returning columnTypes MUST NOT be null");
        }
        int numColumns = columnTypes.size();
        if (numColumns == 1) {
            TypeInfo type = columnTypes.get(0);
            returnOI = HCatRecordObjectInspectorFactory.getStandardObjectInspectorFromTypeInfo(type);
        } else {
            if (columnNames == null) {
                columnNames = new ArrayList<String>(numColumns);
                for (int i = 0; i < numColumns; ++i) {
                    columnNames.add("c" + i);
                }
            } else if (columnNames.size() != numColumns) {
                throw new UDFArgumentException("#columnNames != #columnTypes. #columnName=" + columnNames.size() + ", #columnTypes=" + numColumns);
            }
            ObjectInspector[] fieldOIs = new ObjectInspector[numColumns];
            for (int i = 0; i < fieldOIs.length; ++i) {
                TypeInfo type = columnTypes.get(i);
                fieldOIs[i] = HCatRecordObjectInspectorFactory.getStandardObjectInspectorFromTypeInfo(type);
            }
            returnOI = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, Arrays.asList(fieldOIs));
        }
        return returnOI;
    }

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        Object result;
        Object arg0 = args[0].get();
        if (arg0 == null) {
            return null;
        }
        Text jsonString = this.jsonOI.getPrimitiveWritableObject(arg0);
        try {
            result = this.columnNames == null && this.columnTypes != null && this.columnTypes.size() == 1 ? JsonSerdeUtils.deserialize(jsonString, this.columnTypes.get(0)) : JsonSerdeUtils.deserialize(jsonString, this.columnNames, this.columnTypes);
        }
        catch (Throwable e) {
            throw new HiveException("Failed to deserialize Json: \n" + jsonString.toString() + '\n' + ExceptionUtils.prettyPrintStackTrace(e), e);
        }
        return result;
    }

    public String getDisplayString(String[] args) {
        return "from_json(" + StringUtils.join(args, ',') + ")";
    }
}

