/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.list;

import hivemall.utils.collections.BoundedPriorityQueue;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.CommandLineUtils;
import hivemall.utils.lang.NaturalComparator;
import hivemall.utils.lang.Preconditions;
import hivemall.utils.struct.Pair;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.IntWritable;

@Description(name="to_ordered_list", value="_FUNC_(PRIMITIVE value [, PRIMITIVE key, const string options]) - Return list of values sorted by value itself or specific key", extended="WITH t as (\n    SELECT 5 as key, 'apple' as value\n    UNION ALL\n    SELECT 3 as key, 'banana' as value\n    UNION ALL\n    SELECT 4 as key, 'candy' as value\n    UNION ALL\n    SELECT 2 as key, 'donut' as value\n    UNION ALL\n    SELECT 3 as key, 'egg' as value\n)\nSELECT                                             -- expected output\n    to_ordered_list(value, key, '-reverse'),       -- [apple, candy, (banana, egg | egg, banana), donut] (reverse order)\n    to_ordered_list(value, key, '-k 2'),           -- [apple, candy] (top-k)\n    to_ordered_list(value, key, '-k 100'),         -- [apple, candy, (banana, egg | egg, banana), dunut]\n    to_ordered_list(value, key, '-k 2 -reverse'),  -- [donut, (banana | egg)] (reverse top-k = tail-k)\n    to_ordered_list(value, key),                   -- [donut, (banana, egg | egg, banana), candy, apple] (natural order)\n    to_ordered_list(value, key, '-k -2'),          -- [donut, (banana | egg)] (tail-k)\n    to_ordered_list(value, key, '-k -100'),        -- [donut, (banana, egg | egg, banana), candy, apple]\n    to_ordered_list(value, key, '-k -2 -reverse'), -- [apple, candy] (reverse tail-k = top-k)\n    to_ordered_list(value, '-k 2'),                -- [egg, donut] (alphabetically)\n    to_ordered_list(key, '-k -2 -reverse'),        -- [5, 4] (top-2 keys)\n    to_ordered_list(key),                          -- [2, 3, 3, 4, 5] (natural ordered keys)\n    to_ordered_list(value, key, '-k 2 -kv_map'),   -- {4:\"candy\",5:\"apple\"}\n    to_ordered_list(value, key, '-k 2 -vk_map')    -- {\"candy\":4,\"apple\":5}\nFROM\n    t")
public final class UDAFToOrderedList
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        TypeInfo[] typeInfo = info.getParameters();
        ObjectInspector[] argOIs = info.getParameterObjectInspectors();
        if (typeInfo.length == 1 || typeInfo.length == 2 && HiveUtils.isConstString(argOIs[1])) {
            if (typeInfo[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted for value but " + typeInfo[0].getTypeName() + " was passed as the first parameter.");
            }
        } else if (typeInfo.length == 2 || typeInfo.length == 3 && HiveUtils.isConstString(argOIs[2])) {
            if (typeInfo[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UDFArgumentTypeException(1, "Only primitive type arguments are accepted for key but " + typeInfo[1].getTypeName() + " was passed as the second parameter.");
            }
        } else {
            throw new UDFArgumentTypeException(typeInfo.length - 1, "Number of arguments must be in [1, 3] including constant string for options: " + typeInfo.length);
        }
        return new UDAFToOrderedListEvaluator();
    }

    public static class UDAFToOrderedListEvaluator
    extends GenericUDAFEvaluator {
        private ObjectInspector valueOI;
        private PrimitiveObjectInspector keyOI;
        private ListObjectInspector valueListOI;
        private ListObjectInspector keyListOI;
        private StructObjectInspector internalMergeOI;
        private StructField valueListField;
        private StructField keyListField;
        private StructField sizeField;
        private StructField reverseOrderField;
        private StructField outKVField;
        private StructField outVKField;
        @Nonnegative
        private int size;
        private boolean reverseOrder;
        private boolean sortByKey;
        private boolean outKV;
        private boolean outVK;

        protected Options getOptions() {
            Options opts = new Options();
            opts.addOption("k", true, "To top-k (positive) or tail-k (negative) ordered queue");
            opts.addOption("reverse", "reverse_order", false, "Sort values by key in a reverse (e.g., descending) order [default: false]");
            opts.addOption("kv", "kv_map", false, "Return Map<K, V> for the result of to_ordered_list(V, K)");
            opts.addOption("vk", "vk_map", false, "Return Map<V, K> for the result of to_ordered_list(V, K)");
            return opts;
        }

        @Nonnull
        protected final CommandLine parseOptions(String optionValue) throws UDFArgumentException {
            String[] args = optionValue.split("\\s+");
            Options opts = this.getOptions();
            opts.addOption("help", false, "Show function help");
            CommandLine cl = CommandLineUtils.parseOptions(args, opts);
            if (cl.hasOption("help")) {
                String funcName;
                Description funcDesc = ((Object)((Object)this)).getClass().getAnnotation(Description.class);
                String cmdLineSyntax = funcDesc == null ? ((Object)((Object)this)).getClass().getSimpleName() : ((funcName = funcDesc.name()) == null ? ((Object)((Object)this)).getClass().getSimpleName() : funcDesc.value().replace("_FUNC_", funcDesc.name()));
                StringWriter sw = new StringWriter();
                sw.write(10);
                PrintWriter pw = new PrintWriter(sw);
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(pw, 74, cmdLineSyntax, null, opts, 1, 3, null, true);
                pw.flush();
                String helpMsg = sw.toString();
                throw new UDFArgumentException(helpMsg);
            }
            return cl;
        }

        protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
            CommandLine cl = null;
            int optionIndex = 1;
            if (this.sortByKey) {
                optionIndex = 2;
            }
            int k = 0;
            boolean reverseOrder = false;
            boolean outKV = false;
            boolean outVK = false;
            if (argOIs.length >= optionIndex + 1) {
                String rawArgs = HiveUtils.getConstString(argOIs[optionIndex]);
                cl = this.parseOptions(rawArgs);
                reverseOrder = cl.hasOption("reverse_order");
                if (cl.hasOption("k") && (k = Integer.parseInt(cl.getOptionValue("k"))) == 0) {
                    throw new UDFArgumentException("`k` must be non-zero value: " + k);
                }
                outKV = cl.hasOption("kv_map");
                outVK = cl.hasOption("vk_map");
                if (outKV && outVK) {
                    throw new UDFArgumentException("Both `-kv_map` and `-vk_map` option are unexpectedly specified");
                }
                if (outKV && !this.sortByKey) {
                    throw new UDFArgumentException("`-kv_map` option can only be applied when both key and value are provided");
                }
                if (outVK && !this.sortByKey) {
                    throw new UDFArgumentException("`-vk_map` option can only be applied when both key and value are provided");
                }
            }
            this.size = Math.abs(k);
            this.outKV = outKV;
            this.outVK = outVK;
            this.reverseOrder = k > 0 && reverseOrder || k < 0 && !reverseOrder || k == 0 && !reverseOrder;
            return cl;
        }

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] argOIs) throws HiveException {
            super.init(mode, argOIs);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                boolean bl = this.sortByKey = argOIs.length == 2 && !HiveUtils.isConstString(argOIs[1]) || argOIs.length == 3 && HiveUtils.isConstString(argOIs[2]);
                if (this.sortByKey) {
                    this.valueOI = argOIs[0];
                    this.keyOI = HiveUtils.asPrimitiveObjectInspector(argOIs[1]);
                } else {
                    this.valueOI = HiveUtils.asPrimitiveObjectInspector(argOIs[0]);
                    this.keyOI = HiveUtils.asPrimitiveObjectInspector(argOIs[0]);
                }
                this.processOptions(argOIs);
            } else {
                StructObjectInspector soi;
                this.internalMergeOI = soi = (StructObjectInspector)argOIs[0];
                this.valueListField = soi.getStructFieldRef("valueList");
                StandardListObjectInspector valueListOI = (StandardListObjectInspector)this.valueListField.getFieldObjectInspector();
                this.valueOI = valueListOI.getListElementObjectInspector();
                this.valueListOI = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.valueOI);
                this.keyListField = soi.getStructFieldRef("keyList");
                StandardListObjectInspector keyListOI = (StandardListObjectInspector)this.keyListField.getFieldObjectInspector();
                this.keyOI = HiveUtils.asPrimitiveObjectInspector(keyListOI.getListElementObjectInspector());
                this.keyListOI = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.keyOI);
                this.sizeField = soi.getStructFieldRef("size");
                this.reverseOrderField = soi.getStructFieldRef("reverseOrder");
                List fieldRefs = soi.getAllStructFieldRefs();
                this.outKVField = HiveUtils.getStructFieldRef("outKV", fieldRefs);
                if (this.outKVField != null) {
                    this.outKV = true;
                }
                this.outVKField = HiveUtils.getStructFieldRef("outVK", fieldRefs);
                if (this.outVKField != null) {
                    this.outVK = true;
                }
            }
            Object outputOI = mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2 ? this.internalMergeOI(this.valueOI, this.keyOI, this.outKV, this.outVK) : (this.outKV ? ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.keyOI), (ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.valueOI)) : (this.outVK ? ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.valueOI), (ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.keyOI)) : ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.valueOI))));
            return outputOI;
        }

        @Nonnull
        private StructObjectInspector internalMergeOI(@Nonnull ObjectInspector valueOI, @Nonnull PrimitiveObjectInspector keyOI, boolean outKV, boolean outVK) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            ArrayList<Object> fieldOIs = new ArrayList<Object>();
            fieldNames.add("valueList");
            fieldOIs.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)valueOI)));
            fieldNames.add("keyList");
            fieldOIs.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)keyOI)));
            fieldNames.add("size");
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
            fieldNames.add("reverseOrder");
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
            if (outKV) {
                fieldNames.add("outKV");
                fieldOIs.add(PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
            } else if (outVK) {
                fieldNames.add("outVK");
                fieldOIs.add(PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
            }
            return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            QueueAggregationBuffer myagg = new QueueAggregationBuffer();
            this.reset((GenericUDAFEvaluator.AggregationBuffer)myagg);
            return myagg;
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            QueueAggregationBuffer myagg = (QueueAggregationBuffer)agg;
            myagg.reset(this.size, this.reverseOrder, this.outKV, this.outVK);
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Object key;
            if (parameters[0] == null) {
                return;
            }
            Object value = ObjectInspectorUtils.copyToStandardObject((Object)parameters[0], (ObjectInspector)this.valueOI);
            if (this.sortByKey) {
                if (parameters[1] == null) {
                    return;
                }
                key = ObjectInspectorUtils.copyToStandardObject((Object)parameters[1], (ObjectInspector)this.keyOI);
            } else {
                key = ObjectInspectorUtils.copyToStandardObject((Object)parameters[0], (ObjectInspector)this.valueOI);
            }
            TupleWithKey tuple = new TupleWithKey(key, value);
            QueueAggregationBuffer myagg = (QueueAggregationBuffer)agg;
            myagg.iterate(tuple);
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            QueueAggregationBuffer myagg = (QueueAggregationBuffer)agg;
            Pair<List<Object>, List<Object>> tuples = myagg.drainQueue();
            if (tuples == null) {
                return null;
            }
            List keyList = (List)tuples.getKey();
            List valueList = (List)tuples.getValue();
            Object[] partialResult = new Object[this.outKV || this.outVK ? 5 : 4];
            partialResult[0] = valueList;
            partialResult[1] = keyList;
            partialResult[2] = new IntWritable(myagg.size);
            partialResult[3] = new BooleanWritable(myagg.reverseOrder);
            if (myagg.outKV) {
                partialResult[4] = new BooleanWritable(true);
            } else if (myagg.outVK) {
                partialResult[4] = new BooleanWritable(true);
            }
            return partialResult;
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial == null) {
                return;
            }
            Object valueListObj = this.internalMergeOI.getStructFieldData(partial, this.valueListField);
            List valueListRaw = this.valueListOI.getList(HiveUtils.castLazyBinaryObject(valueListObj));
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (Object v : valueListRaw) {
                valueList.add(ObjectInspectorUtils.copyToStandardObject(v, (ObjectInspector)this.valueOI));
            }
            Object keyListObj = this.internalMergeOI.getStructFieldData(partial, this.keyListField);
            List keyListRaw = this.keyListOI.getList(HiveUtils.castLazyBinaryObject(keyListObj));
            ArrayList<Object> keyList = new ArrayList<Object>();
            for (Object k : keyListRaw) {
                keyList.add(ObjectInspectorUtils.copyToStandardObject(k, (ObjectInspector)this.keyOI));
            }
            Object sizeObj = this.internalMergeOI.getStructFieldData(partial, this.sizeField);
            int size = PrimitiveObjectInspectorFactory.writableIntObjectInspector.get(sizeObj);
            Object reverseOrderObj = this.internalMergeOI.getStructFieldData(partial, this.reverseOrderField);
            boolean reverseOrder = PrimitiveObjectInspectorFactory.writableBooleanObjectInspector.get(reverseOrderObj);
            QueueAggregationBuffer myagg = (QueueAggregationBuffer)agg;
            myagg.setOptions(size, reverseOrder, this.outKV, this.outVK);
            myagg.merge(keyList, valueList);
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            QueueAggregationBuffer myagg = (QueueAggregationBuffer)agg;
            if (myagg.outKV) {
                return myagg.drainMapKV();
            }
            if (myagg.outVK) {
                return myagg.drainMapVK();
            }
            return myagg.drainValues();
        }

        private static final class TupleWithKey
        implements Comparable<TupleWithKey> {
            @Nonnull
            private final Object key;
            @Nonnull
            private final Object value;

            TupleWithKey(@CheckForNull Object key, @CheckForNull Object value) {
                this.key = Preconditions.checkNotNull(key);
                this.value = Preconditions.checkNotNull(value);
            }

            @Nonnull
            Object getKey() {
                return this.key;
            }

            @Nonnull
            Object getValue() {
                return this.value;
            }

            @Override
            public int compareTo(TupleWithKey o) {
                Comparable k = (Comparable)this.key;
                return k.compareTo(o.getKey());
            }
        }

        private static final class BoundedQueueHandler
        extends AbstractQueueHandler {
            @Nonnull
            private final BoundedPriorityQueue<TupleWithKey> queue;

            BoundedQueueHandler(int size, @Nonnull Comparator<TupleWithKey> comparator) {
                this.queue = new BoundedPriorityQueue<TupleWithKey>(size, comparator);
            }

            @Override
            void offer(TupleWithKey tuple) {
                this.queue.offer(tuple);
            }

            @Override
            int size() {
                return this.queue.size();
            }

            @Override
            TupleWithKey poll() {
                return this.queue.poll();
            }

            @Override
            void clear() {
                this.queue.clear();
            }
        }

        private static final class QueueHandler
        extends AbstractQueueHandler {
            private static final int DEFAULT_INITIAL_CAPACITY = 11;
            @Nonnull
            private final PriorityQueue<TupleWithKey> queue;

            QueueHandler(@Nonnull Comparator<TupleWithKey> comparator) {
                this.queue = new PriorityQueue<TupleWithKey>(11, comparator);
            }

            @Override
            void offer(TupleWithKey tuple) {
                this.queue.offer(tuple);
            }

            @Override
            int size() {
                return this.queue.size();
            }

            @Override
            TupleWithKey poll() {
                return this.queue.poll();
            }

            @Override
            void clear() {
                this.queue.clear();
            }
        }

        private static abstract class AbstractQueueHandler {
            private AbstractQueueHandler() {
            }

            abstract void offer(@Nonnull TupleWithKey var1);

            abstract int size();

            @Nullable
            abstract TupleWithKey poll();

            abstract void clear();
        }

        static class QueueAggregationBuffer
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            private transient AbstractQueueHandler queueHandler;
            @Nonnegative
            private int size;
            private boolean reverseOrder;
            private boolean outKV;
            private boolean outVK;

            QueueAggregationBuffer() {
            }

            void reset(@Nonnegative int size, boolean reverseOrder, boolean outKV, boolean outVK) {
                this.setOptions(size, reverseOrder, outKV, outVK);
                this.queueHandler = null;
            }

            void setOptions(@Nonnegative int size, boolean reverseOrder, boolean outKV, boolean outVK) {
                this.size = size;
                this.reverseOrder = reverseOrder;
                this.outKV = outKV;
                this.outVK = outVK;
            }

            void iterate(@Nonnull TupleWithKey tuple) {
                if (this.queueHandler == null) {
                    this.initQueueHandler();
                }
                this.queueHandler.offer(tuple);
            }

            void merge(@Nonnull List<Object> keys, @Nonnull List<Object> values) {
                if (this.queueHandler == null) {
                    this.initQueueHandler();
                }
                int n = keys.size();
                for (int i = 0; i < n; ++i) {
                    this.queueHandler.offer(new TupleWithKey(keys.get(i), values.get(i)));
                }
            }

            @Deprecated
            @Nullable
            Pair<List<Object>, List<Object>> drainQueue() {
                if (this.queueHandler == null) {
                    return null;
                }
                int n = this.queueHandler.size();
                Object[] keys = new Object[n];
                Object[] values = new Object[n];
                for (int i = n - 1; i >= 0; --i) {
                    TupleWithKey tuple = this.queueHandler.poll();
                    keys[i] = tuple.getKey();
                    values[i] = tuple.getValue();
                }
                this.queueHandler.clear();
                return Pair.of(Arrays.asList(keys), Arrays.asList(values));
            }

            @Nullable
            List<Object> drainValues() {
                if (this.queueHandler == null) {
                    return null;
                }
                int n = this.queueHandler.size();
                Object[] values = new Object[n];
                for (int i = n - 1; i >= 0; --i) {
                    TupleWithKey tuple = this.queueHandler.poll();
                    values[i] = tuple.getValue();
                }
                this.queueHandler.clear();
                return Arrays.asList(values);
            }

            @Nullable
            Map<Object, Object> drainMapKV() {
                if (this.queueHandler == null) {
                    return null;
                }
                int n = this.queueHandler.size();
                HashMap<Object, Object> map = new HashMap<Object, Object>(n * 2);
                for (int i = n - 1; i >= 0; --i) {
                    TupleWithKey tuple = this.queueHandler.poll();
                    Object k = tuple.getKey();
                    if (map.containsKey(k)) continue;
                    Object v = tuple.getValue();
                    map.put(k, v);
                }
                this.queueHandler.clear();
                return map;
            }

            @Nullable
            Map<Object, Object> drainMapVK() {
                if (this.queueHandler == null) {
                    return null;
                }
                int n = this.queueHandler.size();
                HashMap<Object, Object> map = new HashMap<Object, Object>(n * 2);
                for (int i = n - 1; i >= 0; --i) {
                    TupleWithKey tuple = this.queueHandler.poll();
                    Object k = tuple.getValue();
                    if (map.containsKey(k)) continue;
                    Object v = tuple.getKey();
                    map.put(k, v);
                }
                this.queueHandler.clear();
                return map;
            }

            private void initQueueHandler() {
                Comparator<TupleWithKey> comparator = this.reverseOrder ? Collections.reverseOrder() : NaturalComparator.getInstance();
                this.queueHandler = this.size > 0 ? new BoundedQueueHandler(this.size, comparator) : new QueueHandler(comparator);
            }
        }
    }
}

