/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.map;

import hivemall.utils.hadoop.HiveUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="map_exclude_keys", value="_FUNC_(Map<K,V> map, array<K> filteringKeys) - Returns the filtered entries of a map not having specified keys", extended="SELECT map_exclude_keys(map(1,'one',2,'two',3,'three'),array(2,3));\n{1:\"one\"}")
@UDFType(deterministic=true, stateful=false)
public final class MapExcludeKeysUDF
extends GenericUDF {
    private MapObjectInspector mapOI;
    private ListObjectInspector listOI;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        ObjectInspector filterKeyOI;
        if (argOIs.length != 2) {
            throw new UDFArgumentLengthException("Expected two arguments for map_filter_keys: " + argOIs.length);
        }
        this.mapOI = HiveUtils.asMapOI(argOIs[0]);
        this.listOI = HiveUtils.asListOI(argOIs[1]);
        ObjectInspector mapKeyOI = this.mapOI.getMapKeyObjectInspector();
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)mapKeyOI, (ObjectInspector)(filterKeyOI = this.listOI.getListElementObjectInspector()))) {
            throw new UDFArgumentException("Element types does not match: mapKey " + mapKeyOI.getTypeName() + ", filterKey" + filterKeyOI.getTypeName());
        }
        return ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.mapOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
    }

    public Map<?, ?> evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object arg0 = arguments[0].get();
        if (arg0 == null) {
            return null;
        }
        Map map = (Map)ObjectInspectorUtils.copyToStandardObject((Object)arg0, (ObjectInspector)this.mapOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        Object arg1 = arguments[1].get();
        if (arg1 == null) {
            return map;
        }
        List filterKeys = (List)ObjectInspectorUtils.copyToStandardObject((Object)arg1, (ObjectInspector)this.listOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        for (Object k : filterKeys) {
            map.remove(k);
        }
        return map;
    }

    public String getDisplayString(String[] children) {
        return "map_exclude_keys(" + StringUtils.join((Object[])children, (char)',') + ")";
    }
}

