/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.map;

import hivemall.utils.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

@Description(name="map_get", value="_FUNC_(MAP<K> a, K n) - Returns the value corresponding to the key in the map.", extended="Note this is a workaround for a Hive issue that non-constant expression for map indexes not supported.\nSee https://issues.apache.org/jira/browse/HIVE-1955\n\nWITH tmp as (\n  SELECT \"one\" as key\n  UNION ALL\n  SELECT \"two\" as key\n)\nSELECT map_get(map(\"one\",1,\"two\",2),key)\nFROM tmp;\n\n> 1\n> 2")
@UDFType(deterministic=true, stateful=false)
public final class MapGetUDF
extends GenericUDF {
    private transient MapObjectInspector mapOI;
    private transient ObjectInspectorConverters.Converter converter;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("map_get accepts exactly 2 arguments.");
        }
        if (!(arguments[0] instanceof MapObjectInspector)) {
            throw new UDFArgumentTypeException(0, "\"map\" is expected for the first argument, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.mapOI = (MapObjectInspector)arguments[0];
        if (!(arguments[1] instanceof PrimitiveObjectInspector)) {
            throw new UDFArgumentTypeException(1, "Primitive Type is expected but " + arguments[1].getTypeName() + "\" is found");
        }
        PrimitiveObjectInspector inputOI = (PrimitiveObjectInspector)arguments[1];
        ObjectInspector indexOI = ObjectInspectorConverters.getConvertedOI((ObjectInspector)inputOI, (ObjectInspector)this.mapOI.getMapKeyObjectInspector());
        this.converter = ObjectInspectorConverters.getConverter((ObjectInspector)inputOI, (ObjectInspector)indexOI);
        return this.mapOI.getMapValueObjectInspector();
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        assert (arguments.length == 2);
        Object index = arguments[1].get();
        Object indexObject = this.converter.convert(index);
        if (indexObject == null) {
            return null;
        }
        Object arg0 = arguments[0].get();
        if (arg0 == null) {
            return null;
        }
        return this.mapOI.getMapValueElement(arg0, indexObject);
    }

    public String getDisplayString(String[] children) {
        return "map_get(" + StringUtils.join(children, ',') + ')';
    }
}

