/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.map;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;

@Description(name="map_key_values", value="_FUNC_(MAP<K, V> map) - Returns a array of key-value pairs in array<named_struct<key,value>>", extended="SELECT map_key_values(map(\"one\",1,\"two\",2));\n\n> [{\"key\":\"one\",\"value\":1},{\"key\":\"two\",\"value\":2}]")
@UDFType(deterministic=true, stateful=false)
public final class MapKeyValuesUDF
extends GenericUDF {
    private final ArrayList<Object[]> retArray = new ArrayList();
    private MapObjectInspector mapOI;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("The function MAP_KEYS only accepts one argument.");
        }
        if (!(arguments[0] instanceof MapObjectInspector)) {
            throw new UDFArgumentTypeException(0, "\"" + ObjectInspector.Category.MAP.toString().toLowerCase() + "\" is expected at function MAP_KEYS, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.mapOI = (MapObjectInspector)arguments[0];
        ArrayList<String> structFieldNames = new ArrayList<String>();
        ArrayList<ObjectInspector> structFieldObjectInspectors = new ArrayList<ObjectInspector>();
        structFieldNames.add("key");
        structFieldObjectInspectors.add(this.mapOI.getMapKeyObjectInspector());
        structFieldNames.add("value");
        structFieldObjectInspectors.add(this.mapOI.getMapValueObjectInspector());
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, structFieldObjectInspectors));
    }

    @Nullable
    public List<Object[]> evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object mapObj = arguments[0].get();
        if (mapObj == null) {
            return null;
        }
        this.retArray.clear();
        Map map = this.mapOI.getMap(mapObj);
        for (Map.Entry e : map.entrySet()) {
            this.retArray.add(new Object[]{e.getKey(), e.getValue()});
        }
        return this.retArray;
    }

    public String getDisplayString(String[] children) {
        return "map_key_values(" + StringUtils.join((Object[])children, (char)',') + ')';
    }
}

