/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.map;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;

@Description(name="map_tail_n", value="_FUNC_(map SRC, int N) - Returns the last N elements from a sorted array of SRC")
@UDFType(deterministic=true, stateful=false)
public class MapTailNUDF
extends GenericUDF {
    private MapObjectInspector mapObjectInspector;
    private IntObjectInspector intObjectInspector;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("map_tail_n only takes 2 arguments: map<object, object>, int");
        }
        if (!(arguments[0] instanceof MapObjectInspector)) {
            throw new UDFArgumentException("The first argument must be a map");
        }
        this.mapObjectInspector = (MapObjectInspector)arguments[0];
        if (!(arguments[1] instanceof IntObjectInspector)) {
            throw new UDFArgumentException("The second argument must be an int");
        }
        this.intObjectInspector = (IntObjectInspector)arguments[1];
        ObjectInspector keyOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.mapObjectInspector.getMapKeyObjectInspector());
        ObjectInspector valueOI = this.mapObjectInspector.getMapValueObjectInspector();
        return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyOI, (ObjectInspector)valueOI);
    }

    public Map<?, ?> evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object mapObj = arguments[0].get();
        Map map = this.mapObjectInspector.getMap(mapObj);
        int n = this.intObjectInspector.get(arguments[1].get());
        Map<Object, Object> ret = this.tailN(map, n);
        return ret;
    }

    public String getDisplayString(String[] arguments) {
        return "map_tail_n( " + Arrays.toString(arguments) + " )";
    }

    private Map<Object, Object> tailN(Map<?, ?> m, int n) {
        Object v;
        Object k;
        ObjectInspector keyInspector = this.mapObjectInspector.getMapKeyObjectInspector();
        TreeMap<Object, Object> tail = new TreeMap<Object, Object>();
        for (Map.Entry<?, ?> e : m.entrySet()) {
            k = ObjectInspectorUtils.copyToStandardObject(e.getKey(), (ObjectInspector)keyInspector);
            v = e.getValue();
            tail.put(k, v);
        }
        if (tail.size() <= n) {
            return tail;
        }
        TreeMap<Object, Object> ret = new TreeMap<Object, Object>();
        for (int i = 0; i < n; ++i) {
            k = tail.lastKey();
            v = tail.remove(k);
            ret.put(k, v);
        }
        return ret;
    }
}

