/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.map;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="merge_maps", value="_FUNC_(Map x) - Returns a map which contains the union of an aggregation of maps. Note that an existing value of a key can be replaced with the other duplicate key entry.", extended="SELECT \n  merge_maps(m) \nFROM (\n  SELECT map('A',10,'B',20,'C',30) \n  UNION ALL \n  SELECT map('A',10,'B',20,'C',30)\n) t")
public final class MergeMapsUDAF
extends AbstractGenericUDAFResolver {
    public MergeMapsEvaluator getEvaluator(TypeInfo[] types) throws SemanticException {
        if (types.length != 1) {
            throw new UDFArgumentTypeException(types.length - 1, "One argument is expected but got " + types.length);
        }
        TypeInfo paramType = types[0];
        if (paramType.getCategory() != ObjectInspector.Category.MAP) {
            throw new UDFArgumentTypeException(0, "Only maps supported for now ");
        }
        return new MergeMapsEvaluator();
    }

    public static final class MergeMapsEvaluator
    extends GenericUDAFEvaluator {
        private transient MapObjectInspector inputMapOI;
        private transient MapObjectInspector mergeMapOI;
        private transient ObjectInspector inputKeyOI;
        private transient ObjectInspector inputValOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
            Preconditions.checkArgument(parameters.length == 1);
            super.init(mode, parameters);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputMapOI = HiveUtils.asMapOI(parameters[0]);
                this.inputKeyOI = this.inputMapOI.getMapKeyObjectInspector();
                this.inputValOI = this.inputMapOI.getMapValueObjectInspector();
            } else {
                this.mergeMapOI = HiveUtils.asMapOI(parameters[0]);
                this.inputKeyOI = this.mergeMapOI.getMapKeyObjectInspector();
                this.inputValOI = this.mergeMapOI.getMapValueObjectInspector();
            }
            return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputKeyOI), (ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputValOI));
        }

        public MapAggBuffer getNewAggregationBuffer() throws HiveException {
            MapAggBuffer buff = new MapAggBuffer();
            this.reset((GenericUDAFEvaluator.AggregationBuffer)buff);
            return buff;
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buff) throws HiveException {
            MapAggBuffer aggrBuf = (MapAggBuffer)buff;
            aggrBuf.collectMap.clear();
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Preconditions.checkArgument(parameters.length == 1);
            Object param0 = parameters[0];
            if (param0 == null) {
                return;
            }
            Map m = this.inputMapOI.getMap(param0);
            MapAggBuffer myagg = (MapAggBuffer)agg;
            MergeMapsEvaluator.putIntoSet(m, myagg.collectMap, this.inputMapOI);
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial == null) {
                return;
            }
            MapAggBuffer myagg = (MapAggBuffer)agg;
            Map m = this.mergeMapOI.getMap(partial);
            MergeMapsEvaluator.putIntoSet(m, myagg.collectMap, this.mergeMapOI);
        }

        private static void putIntoSet(@Nonnull Map<?, ?> m, @Nonnull Map<Object, Object> dst, @Nonnull MapObjectInspector mapOI) {
            ObjectInspector keyOI = mapOI.getMapKeyObjectInspector();
            ObjectInspector valueOI = mapOI.getMapValueObjectInspector();
            for (Map.Entry<?, ?> e : m.entrySet()) {
                Object k = e.getKey();
                Object v = e.getValue();
                Object keyCopy = ObjectInspectorUtils.copyToStandardObject(k, (ObjectInspector)keyOI);
                Object valCopy = ObjectInspectorUtils.copyToStandardObject(v, (ObjectInspector)valueOI);
                dst.put(keyCopy, valCopy);
            }
        }

        @Nonnull
        public Map<Object, Object> terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MapAggBuffer myagg = (MapAggBuffer)agg;
            return myagg.collectMap;
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MapAggBuffer myagg = (MapAggBuffer)agg;
            return myagg.collectMap;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=false)
        static final class MapAggBuffer
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            @Nonnull
            final Map<Object, Object> collectMap = new HashMap<Object, Object>();

            MapAggBuffer() {
            }
        }
    }
}

