/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.map;

import hivemall.utils.hadoop.HiveUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="to_map", value="_FUNC_(key, value) - Convert two aggregated columns into a key-value map", extended="WITH input as (\n  select 'aaa' as key, 111 as value\n  UNION all\n  select 'bbb' as key, 222 as value\n)\nselect to_map(key, value)\nfrom input;\n\n> {\"bbb\":222,\"aaa\":111}")
public class UDAFToMap
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] typeInfo) throws SemanticException {
        if (typeInfo.length != 2) {
            throw new UDFArgumentTypeException(typeInfo.length - 1, "Expecting exactly two arguments: " + typeInfo.length);
        }
        if (typeInfo[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted for the key but " + typeInfo[0].getTypeName() + " was passed as parameter 1.");
        }
        return new UDAFToMapEvaluator();
    }

    public static class UDAFToMapEvaluator
    extends GenericUDAFEvaluator {
        protected PrimitiveObjectInspector inputKeyOI;
        protected ObjectInspector inputValueOI;
        protected StandardMapObjectInspector internalMergeOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] argOIs) throws HiveException {
            super.init(mode, argOIs);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputKeyOI = HiveUtils.asPrimitiveObjectInspector(argOIs[0]);
                this.inputValueOI = argOIs[1];
            } else {
                this.internalMergeOI = (StandardMapObjectInspector)argOIs[0];
                this.inputKeyOI = HiveUtils.asPrimitiveObjectInspector(this.internalMergeOI.getMapKeyObjectInspector());
                this.inputValueOI = this.internalMergeOI.getMapValueObjectInspector();
            }
            return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputKeyOI), (ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputValueOI));
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((MapAggregationBuffer)agg).container = new HashMap<Object, Object>(64);
        }

        public MapAggregationBuffer getNewAggregationBuffer() throws HiveException {
            MapAggregationBuffer ret = new MapAggregationBuffer();
            this.reset((GenericUDAFEvaluator.AggregationBuffer)ret);
            return ret;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            assert (parameters.length == 2);
            Object key = parameters[0];
            Object value = parameters[1];
            if (key != null) {
                MapAggregationBuffer myagg = (MapAggregationBuffer)agg;
                this.putIntoMap(key, value, myagg);
            }
        }

        public Map<Object, Object> terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MapAggregationBuffer myagg = (MapAggregationBuffer)agg;
            return myagg.container;
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            MapAggregationBuffer myagg = (MapAggregationBuffer)agg;
            Map partialResult = this.internalMergeOI.getMap(partial);
            for (Map.Entry entry : partialResult.entrySet()) {
                this.putIntoMap(entry.getKey(), entry.getValue(), myagg);
            }
        }

        public Map<Object, Object> terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MapAggregationBuffer myagg = (MapAggregationBuffer)agg;
            return myagg.container;
        }

        protected void putIntoMap(Object key, Object value, MapAggregationBuffer myagg) {
            Object pKeyCopy = ObjectInspectorUtils.copyToStandardObject((Object)key, (ObjectInspector)this.inputKeyOI);
            Object pValueCopy = ObjectInspectorUtils.copyToStandardObject((Object)value, (ObjectInspector)this.inputValueOI);
            myagg.container.put(pKeyCopy, pValueCopy);
        }

        static class MapAggregationBuffer
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            Map<Object, Object> container;

            MapAggregationBuffer() {
            }
        }
    }
}

