/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.map;

import hivemall.tools.map.UDAFToMap;
import hivemall.utils.collections.maps.BoundedSortedMap;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.IntWritable;

@Description(name="to_ordered_map", value="_FUNC_(key, value [, const int k|const boolean reverseOrder=false]) - Convert two aggregated columns into an ordered key-value map", extended="with t as (\n    select 10 as key, 'apple' as value\n    union all\n    select 3 as key, 'banana' as value\n    union all\n    select 4 as key, 'candy' as value\n)\nselect\n    to_ordered_map(key, value, true),   -- {10:\"apple\",4:\"candy\",3:\"banana\"} (reverse)\n    to_ordered_map(key, value, 1),      -- {10:\"apple\"} (top-1)\n    to_ordered_map(key, value, 2),      -- {10:\"apple\",4:\"candy\"} (top-2)\n    to_ordered_map(key, value, 3),      -- {10:\"apple\",4:\"candy\",3:\"banana\"} (top-3)\n    to_ordered_map(key, value, 100),    -- {10:\"apple\",4:\"candy\",3:\"banana\"} (top-100)\n    to_ordered_map(key, value),         -- {3:\"banana\",4:\"candy\",10:\"apple\"} (natural)\n    to_ordered_map(key, value, -1),     -- {3:\"banana\"} (tail-1)\n    to_ordered_map(key, value, -2),     -- {3:\"banana\",4:\"candy\"} (tail-2)\n    to_ordered_map(key, value, -3),     -- {3:\"banana\",4:\"candy\",10:\"apple\"} (tail-3)\n    to_ordered_map(key, value, -100)    -- {3:\"banana\",4:\"candy\",10:\"apple\"} (tail-100)\nfrom t")
public final class UDAFToOrderedMap
extends UDAFToMap {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        TypeInfo[] typeInfo = info.getParameters();
        if (typeInfo.length != 2 && typeInfo.length != 3) {
            throw new UDFArgumentTypeException(typeInfo.length - 1, "Expecting two or three arguments: " + typeInfo.length);
        }
        if (typeInfo[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted for the key but " + typeInfo[0].getTypeName() + " was passed as parameter 1.");
        }
        boolean reverseOrder = false;
        int size = 0;
        if (typeInfo.length == 3) {
            ObjectInspector[] argOIs = info.getParameterObjectInspectors();
            ObjectInspector argOI2 = argOIs[2];
            if (HiveUtils.isConstBoolean(argOI2)) {
                reverseOrder = HiveUtils.getConstBoolean(argOI2);
            } else if (HiveUtils.isConstInteger(argOI2)) {
                size = HiveUtils.getConstInt(argOI2);
                if (size == 0) {
                    throw new UDFArgumentException("Map size must be non-zero value: " + size);
                }
                reverseOrder = size > 0;
            } else {
                throw new UDFArgumentTypeException(2, "The third argument must be boolean or int type: " + typeInfo[2].getTypeName());
            }
        }
        if (reverseOrder) {
            if (size == 0) {
                return new ReverseOrderedMapEvaluator();
            }
            return new TopKOrderedMapEvaluator();
        }
        if (size == 0) {
            return new NaturalOrderedMapEvaluator();
        }
        return new TailKOrderedMapEvaluator();
    }

    public static class TailKOrderedMapEvaluator
    extends TopKOrderedMapEvaluator {
        @Override
        void initBuffer(TopKOrderedMapEvaluator.MapAggregationBuffer agg, int size) {
            agg.container = new BoundedSortedMap<Object, Object>(size);
            agg.size = size;
        }
    }

    public static class TopKOrderedMapEvaluator
    extends GenericUDAFEvaluator {
        protected PrimitiveObjectInspector inputKeyOI;
        protected ObjectInspector inputValueOI;
        protected MapObjectInspector partialMapOI;
        protected PrimitiveObjectInspector sizeOI;
        protected StructObjectInspector internalMergeOI;
        protected StructField partialMapField;
        protected StructField sizeField;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] argOIs) throws HiveException {
            super.init(mode, argOIs);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputKeyOI = HiveUtils.asPrimitiveObjectInspector(argOIs[0]);
                this.inputValueOI = argOIs[1];
                this.sizeOI = HiveUtils.asIntegerOI(argOIs[2]);
            } else {
                StructObjectInspector soi;
                this.internalMergeOI = soi = (StructObjectInspector)argOIs[0];
                this.partialMapField = soi.getStructFieldRef("partialMap");
                MapObjectInspector partialMapOI = (MapObjectInspector)this.partialMapField.getFieldObjectInspector();
                this.inputKeyOI = HiveUtils.asPrimitiveObjectInspector(partialMapOI.getMapKeyObjectInspector());
                this.inputValueOI = partialMapOI.getMapValueObjectInspector();
                this.partialMapOI = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputKeyOI), (ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputValueOI));
                this.sizeField = soi.getStructFieldRef("size");
                this.sizeOI = (PrimitiveObjectInspector)this.sizeField.getFieldObjectInspector();
            }
            Object outputOI = mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2 ? TopKOrderedMapEvaluator.internalMergeOI(this.inputKeyOI, this.inputValueOI) : ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputKeyOI), (ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputValueOI));
            return outputOI;
        }

        @Nonnull
        private static StructObjectInspector internalMergeOI(@Nonnull PrimitiveObjectInspector keyOI, @Nonnull ObjectInspector valueOI) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            ArrayList<Object> fieldOIs = new ArrayList<Object>();
            fieldNames.add("partialMap");
            fieldOIs.add(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)keyOI), (ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)valueOI)));
            fieldNames.add("size");
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
            return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MapAggregationBuffer myagg = (MapAggregationBuffer)agg;
            myagg.container = null;
            myagg.size = 0;
        }

        public MapAggregationBuffer getNewAggregationBuffer() throws HiveException {
            MapAggregationBuffer myagg = new MapAggregationBuffer();
            this.reset((GenericUDAFEvaluator.AggregationBuffer)myagg);
            return myagg;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            assert (parameters.length == 3);
            if (parameters[0] == null) {
                return;
            }
            Object key = ObjectInspectorUtils.copyToStandardObject((Object)parameters[0], (ObjectInspector)this.inputKeyOI);
            Object value = ObjectInspectorUtils.copyToStandardObject((Object)parameters[1], (ObjectInspector)this.inputValueOI);
            int size = Math.abs(HiveUtils.getInt(parameters[2], this.sizeOI));
            MapAggregationBuffer myagg = (MapAggregationBuffer)agg;
            if (myagg.container == null) {
                this.initBuffer(myagg, size);
            }
            myagg.container.put(key, value);
        }

        void initBuffer(@Nonnull MapAggregationBuffer agg, @Nonnegative int size) {
            Preconditions.checkArgument(size > 0, "size MUST be greater than zero: " + size);
            agg.container = new BoundedSortedMap<Object, Object>(size, true);
            agg.size = size;
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MapAggregationBuffer myagg = (MapAggregationBuffer)agg;
            Object[] partialResult = new Object[]{myagg.container, new IntWritable(myagg.size)};
            return partialResult;
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial == null) {
                return;
            }
            MapAggregationBuffer myagg = (MapAggregationBuffer)agg;
            Object partialMapObj = this.internalMergeOI.getStructFieldData(partial, this.partialMapField);
            Map partialMap = this.partialMapOI.getMap(HiveUtils.castLazyBinaryObject(partialMapObj));
            if (partialMap == null) {
                return;
            }
            if (myagg.container == null) {
                Object sizeObj = this.internalMergeOI.getStructFieldData(partial, this.sizeField);
                int size = HiveUtils.getInt(sizeObj, this.sizeOI);
                this.initBuffer(myagg, size);
            }
            for (Map.Entry e : partialMap.entrySet()) {
                Object key = ObjectInspectorUtils.copyToStandardObject(e.getKey(), (ObjectInspector)this.inputKeyOI);
                Object value = ObjectInspectorUtils.copyToStandardObject(e.getValue(), (ObjectInspector)this.inputValueOI);
                myagg.container.put(key, value);
            }
        }

        @Nullable
        public Map<Object, Object> terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MapAggregationBuffer myagg = (MapAggregationBuffer)agg;
            return myagg.container;
        }

        static class MapAggregationBuffer
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            @Nullable
            Map<Object, Object> container;
            int size;

            MapAggregationBuffer() {
            }
        }
    }

    public static class ReverseOrderedMapEvaluator
    extends UDAFToMap.UDAFToMapEvaluator {
        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((UDAFToMap.UDAFToMapEvaluator.MapAggregationBuffer)agg).container = new TreeMap(Collections.reverseOrder());
        }
    }

    public static class NaturalOrderedMapEvaluator
    extends UDAFToMap.UDAFToMapEvaluator {
        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((UDAFToMap.UDAFToMapEvaluator.MapAggregationBuffer)agg).container = new TreeMap<Object, Object>();
        }
    }
}

