/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.mapred;

import hivemall.ftvec.ExtractFeatureUDF;
import hivemall.utils.hadoop.HadoopUtils;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.io.IOUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@Description(name="distcache_gets", value="_FUNC_(filepath, key, default_value [, parseKey]) - Returns map<key_type, value_type>|value_type")
@UDFType(deterministic=false, stateful=false)
public final class DistributedCacheLookupUDF
extends GenericUDF {
    private boolean multipleKeyLookup;
    private boolean multipleDefaultValues;
    private boolean parseKey;
    private Object defaultValue;
    private PrimitiveObjectInspector keyInputOI;
    private PrimitiveObjectInspector valueInputOI;
    private ListObjectInspector keysInputOI;
    private ListObjectInspector valuesInputOI;
    private Object2ObjectMap<Object, Object> cache;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        ObjectInspector outputOI;
        if (argOIs.length != 3 && argOIs.length != 4) {
            throw new UDFArgumentException("Invalid number of arguments for distcache_gets(FILEPATH, KEYS, DEFAULT_VAL, PARSE_KEY): " + argOIs.length + DistributedCacheLookupUDF.getUsage());
        }
        if (!ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)argOIs[2])) {
            throw new UDFArgumentException("Third argument DEFAULT_VALUE must be a constant value: " + TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)argOIs[2]));
        }
        this.parseKey = argOIs.length == 4 ? HiveUtils.getConstBoolean(argOIs[3]) : false;
        String filepath = HiveUtils.getConstString(argOIs[0]);
        ObjectInspector argOI2 = argOIs[2];
        boolean bl = this.multipleDefaultValues = argOI2.getCategory() == ObjectInspector.Category.LIST;
        if (this.multipleDefaultValues) {
            this.valuesInputOI = (ListObjectInspector)argOI2;
            ObjectInspector valuesElemOI = this.valuesInputOI.getListElementObjectInspector();
            this.valueInputOI = HiveUtils.asPrimitiveObjectInspector(valuesElemOI);
        } else {
            this.defaultValue = HiveUtils.getConstValue(argOI2);
            this.valueInputOI = HiveUtils.asPrimitiveObjectInspector(argOI2);
        }
        ObjectInspector valueOutputOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.valueInputOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        switch (argOIs[1].getCategory()) {
            case PRIMITIVE: {
                this.multipleKeyLookup = false;
                this.keyInputOI = (PrimitiveObjectInspector)argOIs[1];
                outputOI = valueOutputOI;
                break;
            }
            case LIST: {
                this.multipleKeyLookup = true;
                this.keysInputOI = (ListObjectInspector)argOIs[1];
                ObjectInspector keysElemOI = this.keysInputOI.getListElementObjectInspector();
                this.keyInputOI = HiveUtils.asPrimitiveObjectInspector(keysElemOI);
                outputOI = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)this.keyInputOI, (ObjectInspector)valueOutputOI);
                break;
            }
            default: {
                throw new UDFArgumentException("Unexpected key type: " + argOIs[1].getTypeName());
            }
        }
        if (this.parseKey && !HiveUtils.isStringOI((ObjectInspector)this.keyInputOI)) {
            throw new UDFArgumentException("parseKey=true is only available for string typed key(s)");
        }
        Object2ObjectOpenHashMap<Object, Object> map = new Object2ObjectOpenHashMap<Object, Object>(8192);
        try {
            DistributedCacheLookupUDF.loadValues(map, new File(filepath), this.keyInputOI, this.valueInputOI);
            this.cache = map;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SerDeException e) {
            throw new RuntimeException(e);
        }
        return outputOI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadValues(Object2ObjectMap<Object, Object> map, File file, PrimitiveObjectInspector keyOI, PrimitiveObjectInspector valueOI) throws IOException, SerDeException {
        block8: {
            if (!file.exists()) {
                return;
            }
            if (file.getName().endsWith(".crc")) break block8;
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    DistributedCacheLookupUDF.loadValues(map, f, keyOI, valueOI);
                }
            } else {
                LazySimpleSerDe serde = HiveUtils.getKeyValueLineSerde(keyOI, valueOI);
                StructObjectInspector lineOI = (StructObjectInspector)serde.getObjectInspector();
                StructField keyRef = lineOI.getStructFieldRef("key");
                StructField valueRef = lineOI.getStructFieldRef("value");
                PrimitiveObjectInspector keyRefOI = (PrimitiveObjectInspector)keyRef.getFieldObjectInspector();
                PrimitiveObjectInspector valueRefOI = (PrimitiveObjectInspector)valueRef.getFieldObjectInspector();
                BufferedReader reader = null;
                try {
                    String line;
                    reader = HadoopUtils.getBufferedReader(file);
                    while ((line = reader.readLine()) != null) {
                        Text lineText = new Text(line);
                        Object lineObj = serde.deserialize((Writable)lineText);
                        List fields = lineOI.getStructFieldsDataAsList(lineObj);
                        Object f0 = fields.get(0);
                        Object f1 = fields.get(1);
                        Object k = keyRefOI.getPrimitiveJavaObject(f0);
                        Object v = valueRefOI.getPrimitiveWritableObject(valueRefOI.copyObject(f1));
                        map.put(k, v);
                    }
                }
                finally {
                    IOUtils.closeQuietly((Closeable)reader);
                }
            }
        }
    }

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        Object arg1 = args[1].get();
        if (this.multipleKeyLookup) {
            if (this.multipleDefaultValues) {
                Object arg2 = args[2].get();
                return this.gets(arg1, arg2);
            }
            return this.gets(arg1);
        }
        return this.get(arg1);
    }

    private Object get(Object arg) {
        Object key = this.keyInputOI.getPrimitiveJavaObject(arg);
        Object value = this.cache.get(this.lookupKey(key));
        return value == null ? this.defaultValue : value;
    }

    private Map<Object, Object> gets(Object arg) {
        List keys = this.keysInputOI.getList(arg);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Object k : keys) {
            if (k == null) continue;
            Object kj = this.keyInputOI.getPrimitiveJavaObject(k);
            Object v = this.cache.get(this.lookupKey(kj));
            if (v == null) {
                map.put(k, this.defaultValue);
                continue;
            }
            map.put(k, v);
        }
        return map;
    }

    private Map<Object, Object> gets(Object argKeys, Object argValues) throws HiveException {
        List keys = this.keysInputOI.getList(argKeys);
        List defaultValues = this.valuesInputOI.getList(argValues);
        int numKeys = keys.size();
        if (numKeys != defaultValues.size()) {
            throw new HiveException("# of default values != # of lookup keys: keys " + argKeys + ", values: " + argValues);
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < numKeys; ++i) {
            Object k = keys.get(i);
            if (k == null) continue;
            Object kj = this.keyInputOI.getPrimitiveJavaObject(k);
            Object v = this.cache.get(this.lookupKey(kj));
            if (v == null && (v = defaultValues.get(i)) != null) {
                v = this.valueInputOI.getPrimitiveWritableObject(this.valueInputOI.copyObject(v));
            }
            map.put(k, v);
        }
        return map;
    }

    private Object lookupKey(Object key) {
        if (this.parseKey) {
            String keyStr = key.toString();
            return ExtractFeatureUDF.extractFeature(keyStr);
        }
        return key;
    }

    public String getDisplayString(String[] args) {
        return "distcache_gets()";
    }

    private static String getUsage() {
        return "\nUSAGE: \n\tdistcache_gets(const string FILEPATH, object[] keys, const object defaultValue [, const boolean parseKey])::map<key_type, value_type>\n\tdistcache_gets(const string FILEPATH, object key, const object defaultValue [, const boolean parseKey])::value_type\n\tdistcache_gets(const string FILEPATH, object[] key, object[] defaultValues [, const boolean parseKey])::map<key_type, value_type>";
    }
}

