/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.mapred;

import hivemall.utils.hadoop.HadoopUtils;
import hivemall.utils.hadoop.WritableUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.Text;

@Description(name="rowid", value="_FUNC_() - Returns a generated row id of a form {TASK_ID}-{SEQUENCE_NUMBER}")
@UDFType(deterministic=false, stateful=true)
public class RowIdUDF
extends UDF {
    private long sequence = 0L;
    private int taskId = -1;

    public Text evaluate() {
        if (this.taskId == -1) {
            this.taskId = HadoopUtils.getTaskId() + 1;
        }
        ++this.sequence;
        String rowid = this.taskId + "-" + this.sequence;
        return WritableUtils.val(rowid);
    }
}

