/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.mapred;

import hivemall.utils.hadoop.HadoopUtils;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.LongWritable;

@Description(name="rownum", value="_FUNC_() - Returns a generated row number `sprintf(`%d%04d`,sequence,taskId)` in long", extended="SELECT rownum() as rownum, xxx from ...")
@UDFType(deterministic=false, stateful=true)
public final class RowNumberUDF
extends UDF {
    private long sequence = 0L;
    private int taskId = -1;
    @Nonnull
    private final LongWritable result = new LongWritable(Double.doubleToLongBits(Double.NaN));

    @Nonnull
    public LongWritable evaluate() throws HiveException {
        long l;
        if (this.taskId == -1) {
            this.taskId = HadoopUtils.getTaskId() + 1;
            if (this.taskId > 9999) {
                throw new HiveException("TaskId out of range `" + this.taskId + "`. rownum() supports 9999 tasks at max");
            }
        }
        ++this.sequence;
        String rowid = String.format("%d%04d", this.sequence, this.taskId);
        try {
            l = Long.parseLong(rowid);
        }
        catch (NumberFormatException e) {
            throw new HiveException("failed to parse `" + rowid + "` as long", (Throwable)e);
        }
        this.result.set(l);
        return this.result;
    }
}

